/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.misc;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class FirstJoinMessages
extends AEFModule
implements Listener {
    private final AtomicInteger totalPlayers = new AtomicInteger(0);
    private final boolean logFirstJoin = this.config.getBoolean(this.configPath + ".show-in-console", true);

    public FirstJoinMessages() {
        super("misc.join-leave-messages.first-join-messages", false, "Configure message in lang folder.\nYou can hide yourself and other players using the permission:\n" + AEFPermission.SILENT_JOIN.node());
    }

    @Override
    public void enable() {
        CompletableFuture.runAsync(() -> this.totalPlayers.set(this.plugin.getServer().getOfflinePlayers().length)).thenRun(() -> this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin));
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerJoin(PlayerJoinEvent event) {
        Player joiningPlayer = event.getPlayer();
        if (joiningPlayer.hasPlayedBefore()) {
            return;
        }
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)joiningPlayer, AEFPermission.SILENT_JOIN.node()).toBoolean()) {
            return;
        }
        int playersNumber = this.totalPlayers.incrementAndGet();
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            AnarchyExploitFixes.datastore().getFirstJoinEnabled(onlinePlayer.getUniqueId()).thenAccept(enabled -> {
                if (enabled.booleanValue()) {
                    AnarchyExploitFixes.translation((String)onlinePlayer.getLocale()).misc_firstJoinMessage.forEach(line -> onlinePlayer.sendMessage(line.replace("%player%", joiningPlayer.getName()).replace("%players_num%", Integer.toString(playersNumber))));
                }
            });
        }
        if (this.logFirstJoin) {
            AnarchyExploitFixes.translation((String)joiningPlayer.getLocale()).misc_firstJoinMessage.forEach(line -> this.plugin.getServer().getConsoleSender().sendMessage(line.replace("%player%", joiningPlayer.getName()).replace("%players_num%", Integer.toString(playersNumber))));
        }
    }
}

