/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.misc;

import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class JoinLeaveMessages
extends AEFModule
implements Listener {
    private final boolean showInConsole;
    private final boolean firstJoinEnabled;

    public JoinLeaveMessages() {
        super("misc.join-leave-messages", false, "If you want to hide yourself or someone else when logging\ninto the game, use these permissions:\n" + AEFPermission.SILENT_JOIN.node() + ", " + AEFPermission.SILENT_LEAVE.node());
        this.showInConsole = this.config.getBoolean(this.configPath + ".show-in-console", false);
        this.firstJoinEnabled = this.config.getBoolean(this.configPath + ".first-join-messages.enable", false);
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerJoinEvent(PlayerJoinEvent event) {
        event.setJoinMessage(null);
        Player joiningPlayer = event.getPlayer();
        if (this.firstJoinEnabled && !joiningPlayer.hasPlayedBefore()) {
            return;
        }
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)joiningPlayer, AEFPermission.SILENT_JOIN.node()).toBoolean()) {
            return;
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            AnarchyExploitFixes.datastore().getJoinLeaveEnabled(onlinePlayer.getUniqueId()).thenAccept(enabled -> {
                if (enabled.booleanValue()) {
                    onlinePlayer.sendMessage(AnarchyExploitFixes.translation((String)onlinePlayer.getLocale()).misc_joinMessage.replace("%player%", joiningPlayer.getName()));
                }
            });
        }
        if (this.showInConsole) {
            this.plugin.getServer().getConsoleSender().sendMessage(AnarchyExploitFixes.translation((String)joiningPlayer.getLocale()).misc_joinMessage.replace("%player%", joiningPlayer.getName()) + "(" + joiningPlayer.getLocale() + ")");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerLeaveEvent(PlayerQuitEvent event) {
        event.setQuitMessage(null);
        Player leavingPlayer = event.getPlayer();
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)leavingPlayer, AEFPermission.SILENT_LEAVE.node()).toBoolean()) {
            return;
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            if (onlinePlayer.getUniqueId().equals(leavingPlayer.getUniqueId())) continue;
            AnarchyExploitFixes.datastore().getJoinLeaveEnabled(onlinePlayer.getUniqueId()).thenAccept(enabled -> {
                if (enabled.booleanValue()) {
                    onlinePlayer.sendMessage(AnarchyExploitFixes.translation((String)onlinePlayer.getLocale()).misc_leaveMessage.replace("%player%", leavingPlayer.getName()));
                }
            });
        }
        if (this.showInConsole) {
            this.plugin.getServer().getConsoleSender().sendMessage(AnarchyExploitFixes.translation((String)leavingPlayer.getLocale()).misc_leaveMessage.replace("%player%", leavingPlayer.getName()) + "(" + leavingPlayer.getLocale() + ")");
        }
    }
}

