/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.misc;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.modules.AEFModule;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.plugin.Plugin;

public class PreventMessageKick
extends AEFModule
implements Listener {
    private final Set<String> kickMessagesToListenTo;

    public PreventMessageKick() {
        super("misc.kicks.prevent-message-kick", false, "Cancels the kick for specific kick messages.");
        this.kickMessagesToListenTo = this.config.getList(this.configPath + ".kick-messages-to-listen-to", Arrays.asList("Kicked for spamming", "Stop spamming!")).stream().map(String::toLowerCase).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerKick(PlayerKickEvent event) {
        if (this.kickMessagesToListenTo.contains(event.getReason().toLowerCase())) {
            event.setCancelled(true);
        }
    }
}

