/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.packets;

import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.component.ComponentTypes;
import com.github.retrooper.packetevents.protocol.component.PatchableComponentMap;
import com.github.retrooper.packetevents.protocol.component.builtin.item.BundleContents;
import com.github.retrooper.packetevents.protocol.component.builtin.item.ItemBees;
import com.github.retrooper.packetevents.protocol.component.builtin.item.ItemContainerContents;
import com.github.retrooper.packetevents.protocol.item.ItemStack;
import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.nbt.NBTList;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetSlot;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWindowItems;
import java.util.Arrays;
import me.xginko.aef.modules.packets.PacketModule;
import me.xginko.aef.utils.enums.Platform;

public class BeehiveCoordinates
extends PacketModule {
    private final String[] entityDataTagsToRemove;
    private final boolean useComponentSystem;

    public BeehiveCoordinates() {
        super("patches.remove-beehive-coordinates", true, PacketListenerPriority.HIGHEST, "Patches an exploit that allows players to obtain another player's\ncoordinates by trading them for Beehives or Beenests.\nIf the traded item contains any bees, the stored bee's NBT data can\nthen be read from the item.\nThis data includes, but is not limited to:\n- XYZ coordinates of where the bee has its hive\n- XYZ of the bee's last coordinates before entering it's hive\n- XYZ coordinates of where the bee last visited a flower\n- XYZ coordinates of where the bee was first spawned into existence\n- UID of the world the bee was first spawned into existence");
        this.entityDataTagsToRemove = this.config.getList(this.configPath + ".tags", Arrays.asList("Pos", "HivePos", "FlowerPos", "flower_pos", "Paper.Origin", "Paper.OriginWorld", "WorldUUIDMost", "WorldUUIDLeast"), "The NBT tags to filter from the item. These are the Keys that hold \nthe position data. You may add more tags you want removed here.").toArray(new String[0]);
        this.useComponentSystem = Platform.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_5);
    }

    public void onPacketSend(PacketSendEvent event) {
        block9: {
            block7: {
                ItemStack itemStack;
                WrapperPlayServerSetSlot packet;
                block8: {
                    if (event.isCancelled()) {
                        return;
                    }
                    if (event.getPacketType() != PacketType.Play.Server.SET_SLOT) break block7;
                    packet = new WrapperPlayServerSetSlot(event);
                    itemStack = packet.getItem();
                    if (itemStack == null || itemStack.isEmpty()) {
                        return;
                    }
                    if (!this.useComponentSystem) break block8;
                    PatchableComponentMap componentMap = itemStack.getComponents();
                    if (this.filterComponent(componentMap)) {
                        itemStack.setComponents(componentMap);
                        packet.setItem(itemStack);
                        event.markForReEncode(true);
                    }
                    break block9;
                }
                NBTCompound nbt = itemStack.getNBT();
                if (!this.filterNBTCompound(nbt)) break block9;
                itemStack.setNBT(nbt);
                packet.setItem(itemStack);
                event.markForReEncode(true);
                break block9;
            }
            if (event.getPacketType() == PacketType.Play.Server.WINDOW_ITEMS) {
                WrapperPlayServerWindowItems packet = new WrapperPlayServerWindowItems(event);
                for (int i = 0; i < packet.getItems().size(); ++i) {
                    ItemStack itemStack = (ItemStack)packet.getItems().get(i);
                    if (itemStack == null || itemStack.isEmpty()) {
                        return;
                    }
                    if (this.useComponentSystem) {
                        PatchableComponentMap componentMap = itemStack.getComponents();
                        if (!this.filterComponent(componentMap)) continue;
                        itemStack.setComponents(componentMap);
                        packet.getItems().set(i, itemStack);
                        event.markForReEncode(true);
                        continue;
                    }
                    NBTCompound nbt = itemStack.getNBT();
                    if (!this.filterNBTCompound(nbt)) continue;
                    itemStack.setNBT(nbt);
                    packet.getItems().set(i, itemStack);
                    event.markForReEncode(true);
                }
            }
        }
    }

    private boolean filterComponent(PatchableComponentMap componentMap) {
        ItemContainerContents containerContents;
        BundleContents bundleContents;
        boolean needsReEncode = false;
        ItemBees itemBees = (ItemBees)componentMap.get(ComponentTypes.BEES);
        if (itemBees != null) {
            for (int i = 0; i < itemBees.getBees().size(); ++i) {
                ItemBees.BeeEntry beeEntry = (ItemBees.BeeEntry)itemBees.getBees().get(i);
                NBTCompound beeEntityData = beeEntry.getEntityData();
                if (beeEntityData != null) {
                    for (String toRemove : this.entityDataTagsToRemove) {
                        if (beeEntityData.removeTag(toRemove) == null) continue;
                        needsReEncode = true;
                    }
                    if (needsReEncode) {
                        beeEntry.setEntityData(beeEntityData);
                    }
                }
                if (!needsReEncode) continue;
                itemBees.getBees().set(i, beeEntry);
            }
            if (needsReEncode) {
                componentMap.set(ComponentTypes.BEES, (Object)itemBees);
            }
        }
        if ((bundleContents = (BundleContents)componentMap.get(ComponentTypes.BUNDLE_CONTENTS)) != null) {
            for (int i = 0; i < bundleContents.getItems().size(); ++i) {
                ItemStack itemStack = (ItemStack)bundleContents.getItems().get(i);
                PatchableComponentMap patchableComponentMap = itemStack.getComponents();
                if (!this.filterComponent(patchableComponentMap)) continue;
                itemStack.setComponents(patchableComponentMap);
                bundleContents.getItems().set(i, itemStack);
            }
            if (needsReEncode) {
                componentMap.set(ComponentTypes.BUNDLE_CONTENTS, (Object)bundleContents);
            }
        }
        if ((containerContents = (ItemContainerContents)componentMap.get(ComponentTypes.CONTAINER)) != null) {
            for (int i = 0; i < containerContents.getItems().size(); ++i) {
                ItemStack itemStack = (ItemStack)containerContents.getItems().get(i);
                PatchableComponentMap patchableComponentMap = itemStack.getComponents();
                if (!this.filterComponent(patchableComponentMap)) continue;
                itemStack.setComponents(patchableComponentMap);
                containerContents.getItems().set(i, itemStack);
            }
            if (needsReEncode) {
                componentMap.set(ComponentTypes.CONTAINER, (Object)containerContents);
            }
        }
        return needsReEncode;
    }

    private boolean filterNBTCompound(NBTCompound compound) {
        NBTCompound blockEntityTag;
        int i;
        if (compound == null || compound.isEmpty()) {
            return false;
        }
        boolean needsReEncode = false;
        if (compound.getTags().containsKey("Bees")) {
            NBTList bees = compound.getCompoundListTagOrNull("Bees");
            if (bees == null || bees.isEmpty()) {
                return needsReEncode;
            }
            for (i = 0; i < bees.size(); ++i) {
                NBTCompound beeEntity = (NBTCompound)bees.getTag(i);
                NBTCompound beeEntityData = beeEntity.getCompoundTagOrNull("EntityData");
                if (beeEntityData != null) {
                    for (String toRemove : this.entityDataTagsToRemove) {
                        if (beeEntityData.removeTag(toRemove) == null) continue;
                        needsReEncode = true;
                    }
                    if (needsReEncode) {
                        beeEntity.setTag("EntityData", (NBT)beeEntityData);
                    }
                }
                if (!needsReEncode) continue;
                bees.setTag(i, (NBT)beeEntity);
            }
            if (needsReEncode) {
                compound.setTag("Bees", (NBT)bees);
            }
        }
        if (compound.getTags().containsKey("Items")) {
            NBTList items = compound.getCompoundListTagOrNull("Items");
            if (items == null || items.isEmpty()) {
                return needsReEncode;
            }
            for (i = 0; i < items.size(); ++i) {
                NBTCompound item = (NBTCompound)items.getTag(i);
                NBTCompound itemRootCompound = item.getCompoundTagOrNull("tag");
                if (!this.filterNBTCompound(itemRootCompound)) continue;
                item.setTag("tag", (NBT)itemRootCompound);
                items.setTag(i, (NBT)item);
                needsReEncode = true;
            }
            if (needsReEncode) {
                compound.setTag("Items", (NBT)items);
            }
        }
        if (compound.getTags().containsKey("BlockEntityTag") && this.filterNBTCompound(blockEntityTag = compound.getCompoundTagOrNull("BlockEntityTag"))) {
            compound.setTag("BlockEntityTag", (NBT)blockEntityTag);
            needsReEncode = true;
        }
        return needsReEncode;
    }
}

