/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.packets;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import java.time.Duration;
import java.util.UUID;
import me.xginko.aef.modules.packets.PacketModule;
import me.xginko.aef.utils.models.ExpiringSet;

public class CraftingRecipeLag
extends PacketModule {
    private final long cooldownMillis;
    private final boolean log;
    private final boolean kick;
    private ExpiringSet<UUID> cooldowns;

    public CraftingRecipeLag() {
        super("patches.prevent-crafting-recipe-lag-exploit", true, PacketListenerPriority.HIGHEST, "Prevent lag or crash caused by flooding the server with\ncrafting recipe book requests. This can even be done by hand on\nservers with low specs. Only affects versions < 1.16");
        this.cooldownMillis = (long)Math.max(1, this.config.getInt(this.configPath + ".crafting-recipe-delay-in-ticks", 5, "How many ticks a player needs to wait to be able to use\nthe crafting recipe book again")) * 50L;
        this.log = this.config.getBoolean(this.configPath + ".log", false);
        this.kick = this.config.getBoolean(this.configPath + ".kick-player", false);
    }

    @Override
    public void enable() {
        this.cooldowns = new ExpiringSet(Duration.ofMillis(this.cooldownMillis));
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.asAbstract);
    }

    @Override
    public void disable() {
        PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this.asAbstract);
        if (this.cooldowns != null) {
            this.cooldowns.clear();
            this.cooldowns.cleanUp();
            this.cooldowns = null;
        }
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getPacketType() != PacketType.Play.Client.CRAFT_RECIPE_REQUEST) {
            return;
        }
        if (this.cooldowns.contains(event.getUser().getUUID())) {
            event.setCancelled(true);
            this.onCancel(this.log, this.kick, event.getUser());
        } else {
            this.cooldowns.add(event.getUser().getUUID());
        }
    }
}

