/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.packets;

import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerMapData;
import java.time.Duration;
import me.xginko.aef.modules.packets.PacketModule;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.MathUtil;
import me.xginko.aef.utils.enums.Platform;
import me.xginko.aef.utils.models.ExpiringSet;
import me.xginko.aef.utils.models.Lazy;
import org.bukkit.Bukkit;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class MapCursorLag
extends PacketModule {
    private static final Lazy<ExpiringSet<Integer>> MAP_VIEW_CACHE = Lazy.of(() -> new ExpiringSet(Duration.ofHours(4L)));
    private final int maxCursors;
    private final boolean disableTracking;

    public MapCursorLag() {
        super("patches.map-cursor-lag-patch", true, PacketListenerPriority.HIGHEST, "Patches the famous stacked map cursor lag that causes both client and server lag.");
        this.maxCursors = this.config.getInt(this.configPath + ".max-cursors", 32);
        this.disableTracking = this.config.getBoolean(this.configPath + ".disable-tracking", true, "Disables all tracking on active MapViews. Only has an effect on 1.16+ due to lacking API.");
    }

    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() != PacketType.Play.Server.MAP_DATA) {
            return;
        }
        WrapperPlayServerMapData mapData = new WrapperPlayServerMapData(event);
        if (this.disableTracking) {
            int mapId = mapData.getMapId();
            if (!MAP_VIEW_CACHE.get().contains(mapId)) {
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                    MapView bukkitMapView;
                    MapView mapView = bukkitMapView = Platform.getServerVersion().isOlderThanOrEquals(ServerVersion.V_1_12_2) ? Bukkit.getMap((short)((short)mapId)) : ItemUtil.getMapById(mapId);
                    if (bukkitMapView != null && !bukkitMapView.isVirtual()) {
                        ItemUtil.setTrackingMapPosition(bukkitMapView, false);
                    }
                });
            }
        }
        if (mapData.getDecorations() != null && !mapData.getDecorations().isEmpty()) {
            while (mapData.getDecorations().size() > this.maxCursors) {
                mapData.getDecorations().remove(MathUtil.RANDOM.nextInt(mapData.getDecorations().size()));
                event.markForReEncode(true);
            }
        }
    }
}

