/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.packets;

import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPluginMessage;
import com.google.common.io.ByteStreams;
import me.xginko.aef.modules.packets.PacketModule;
import me.xginko.aef.utils.MathUtil;
import me.xginko.aef.utils.enums.Platform;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

public class PurpurBeehiveCrash
extends PacketModule {
    private static final int SIZE_BITS_X = 26;
    private static final int SIZE_BITS_Z = 26;
    private static final int SIZE_BITS_Y = 12;
    private static final int BIT_SHIFT_Z = 12;
    private static final int BIT_SHIFT_X = 38;
    private final String beehive_c2s_channel;
    private final double maxDistanceSquared;
    private final boolean log;
    private final boolean kick;

    public PurpurBeehiveCrash() {
        super("patches.beehive-crash-patch", Platform.PURPUR.isPresent(), PacketListenerPriority.HIGHEST, "Patches a server crash exploit exclusive to Purpur servers.\nThis exploit works due to PurpurClient having a feature that\nlets clients request stored data of a clicked beehive from\nthe server. The server does not check how far the clicked\nbeehive is away from the client enabling a malicious sender\nto load chunks very fast at far away locations by telling\nthe server it clicked a beehive there.");
        this.beehive_c2s_channel = this.config.getString(this.configPath + ".channel", "purpur:beehive_c2s");
        this.maxDistanceSquared = MathUtil.square(this.config.getInt(this.configPath + ".max-distance", 24));
        this.log = this.config.getBoolean(this.configPath + ".log", false);
        this.kick = this.config.getBoolean(this.configPath + ".kick-player", false);
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() != PacketType.Play.Client.PLUGIN_MESSAGE) {
            return;
        }
        if (event.isCancelled() || event.getPlayer() == null) {
            return;
        }
        WrapperPlayClientPluginMessage packet = new WrapperPlayClientPluginMessage(event);
        if (!packet.getChannelName().equalsIgnoreCase(this.beehive_c2s_channel)) {
            return;
        }
        if (this.distanceSquared(ByteStreams.newDataInput((byte[])packet.getData()).readLong(), ((Entity)event.getPlayer()).getLocation()) > this.maxDistanceSquared) {
            event.setCancelled(true);
            this.onCancel(this.log, this.kick, event.getUser());
        }
    }

    private double distanceSquared(long packedBlockPos, Location playerPos) {
        return MathUtil.square((double)this.unpackLongX(packedBlockPos) - playerPos.getX(), (double)this.unpackLongY(packedBlockPos) - playerPos.getY(), (double)this.unpackLongZ(packedBlockPos) - playerPos.getZ());
    }

    private int unpackLongX(long packedPos) {
        return (int)(packedPos << 0 >> 38);
    }

    private int unpackLongY(long packedPos) {
        return (int)(packedPos << 52 >> 52);
    }

    private int unpackLongZ(long packedPos) {
        return (int)(packedPos << 26 >> 38);
    }
}

