/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.patches;

import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.item.mapdecoration.MapDecorationType;
import com.github.retrooper.packetevents.protocol.item.mapdecoration.MapDecorationTypes;
import com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerMapData;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.xginko.aef.modules.packets.PacketModule;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.enums.Platform;
import me.xginko.aef.utils.models.ExpiringSet;
import me.xginko.aef.utils.models.Lazy;
import org.bukkit.Bukkit;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class AntiMapPlayerTracking
extends PacketModule {
    private static final Lazy<ExpiringSet<Integer>> MAP_VIEW_CACHE = Lazy.of(() -> new ExpiringSet(Duration.ofHours(4L)));
    private final List<MapDecorationType> blacklistedDecorationTypes;
    private final boolean unlimitedTracking;

    public AntiMapPlayerTracking() {
        super("patches.disable-map-player-tracking", false, PacketListenerPriority.HIGHEST, "Under certain circumstances, it is possible to systematically track the position\nof other players using maps and decorations. This is an intended vanilla feature,\nbut it can be abused on a large scale with the right client modifications, which\nsome anarchy servers do not allow.\nThis patch filters specific decoration types from map data that is sent to the\nclient, therefore preventing any sort of monitoring no matter the client modification.");
        this.unlimitedTracking = this.config.getBoolean(this.configPath + ".unlimited-tracking", false, "Whether the map will show a smaller position cursor (true),\nor no position cursor (false) when cursor is outside of map's range.");
        this.blacklistedDecorationTypes = this.config.getList(this.configPath + ".blacklisted-decoration-types", Arrays.asList("player", "player_off_map", "player_off_limits"), "Available decoration types:\n\n" + MapDecorationTypes.values().stream().map(MappedEntity::getName).map(ResourceLocation::getKey).sorted().collect(Collectors.joining(",\n"))).stream().map(name -> {
            MapDecorationType decorationType = MapDecorationTypes.getByName((String)name);
            if (decorationType == null) {
                this.notRecognized(MapDecorationType.class, (String)name);
            }
            return decorationType;
        }).collect(Collectors.toList());
    }

    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() != PacketType.Play.Server.MAP_DATA) {
            return;
        }
        WrapperPlayServerMapData mapData = new WrapperPlayServerMapData(event);
        int mapId = mapData.getMapId();
        if (!MAP_VIEW_CACHE.get().contains(mapId)) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                MapView bukkitMapView;
                MapView mapView = bukkitMapView = Platform.getServerVersion().isOlderThanOrEquals(ServerVersion.V_1_12_2) ? Bukkit.getMap((short)((short)mapId)) : ItemUtil.getMapById(mapId);
                if (bukkitMapView != null && !bukkitMapView.isVirtual() && bukkitMapView.isUnlimitedTracking() != this.unlimitedTracking) {
                    bukkitMapView.setUnlimitedTracking(this.unlimitedTracking);
                }
            });
        }
        if (mapData.getDecorations() != null) {
            for (WrapperPlayServerMapData.MapDecoration mapDecoration : mapData.getDecorations()) {
                if (!this.blacklistedDecorationTypes.contains(mapDecoration.getType())) continue;
                mapData.getDecorations().remove(mapDecoration);
                event.markForReEncode(true);
            }
        }
    }
}

