/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.patches;

import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.modules.AEFModule;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.plugin.Plugin;

public class GodMode
extends AEFModule
implements Listener {
    public GodMode() {
        super("patches.experimental-godmode-patch", false, "Removes entities or players if they are invalid, dead or not located\nwithin a ticking chunk. Not sure if this works.");
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onVehicleEnter(VehicleEnterEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (!vehicle.getChunk().isLoaded() || vehicle.isDead() || !vehicle.isValid()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    private void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (player.isInsideVehicle()) {
            Entity vehicle = player.getVehicle();
            if (vehicle == null) {
                this.warn("Player '" + player.getName() + "' is riding a null entity. Dismounting player from entity.");
                player.leaveVehicle();
                return;
            }
            if (!vehicle.isValid()) {
                this.warn("Player '" + player.getName() + "' is riding an invalid entity. Ejecting all passengers.");
                vehicle.eject();
                return;
            }
            if (vehicle.isDead()) {
                this.warn("Player '" + player.getName() + "' is riding a dead entity. Ejecting all passengers.");
                vehicle.eject();
                return;
            }
            if (!vehicle.getChunk().isLoaded()) {
                this.warn("Player '" + player.getName() + "' is riding an entity from a non-ticking chunk. Ejecting all passengers.");
                vehicle.eject();
                return;
            }
        }
        if (!player.isValid() && !player.isDead()) {
            this.warn("Player '" + player.getName() + "' is neither valid nor dead. Kicking player.");
            player.kickPlayer(AnarchyExploitFixes.translation((String)player.getLocale()).misc_MaskedKickMessage);
        }
    }
}

