/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.patches;

import java.time.Duration;
import java.util.UUID;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ItemUtil;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.plugin.Plugin;

public class ItemDataBan
extends AEFModule
implements Listener {
    private final long itemSizeCacheMillis;
    private final long inventorySizeCacheMillis;
    private final int maxBookSize;
    private final int maxItemSize;
    private final int maxInventorySize;
    private final int maxAuthorChars;
    private final int maxTitleChars;
    private final int maxPages;
    private final boolean useUTF16;
    private final boolean kickOnBigBook;
    private Cache<UUID, Integer> cachedItemSizes;
    private Cache<UUID, Integer> cachedInventorySizes;

    public ItemDataBan() {
        super("patches.anti-item-ban", false, "More commonly known as book-ban: \nPrevents player's getting banned from items with big nbt/compound data. \nThis check applies to all item data, not just books.");
        this.useUTF16 = this.config.getBoolean(this.configPath + ".use-UTF-16", false, "If set to false, will use UTF-8. \nCharset to use to encode the result of NBTCompound#toString into \na sequence of bytes. The length of that sequence is then used to \nget the approximate Byte-size of an ItemStack. \nUse the /aef bytesize command to get a better understanding.");
        this.maxBookSize = this.config.getInt(this.configPath + ".max-book-size", 56000);
        this.kickOnBigBook = this.config.getBoolean(this.configPath + ".kick-on-too-large-book-edit", true, "Kicks players when they try to create a book bigger than the limit.");
        this.maxAuthorChars = this.config.getInt(this.configPath + ".max-author-chars", 30);
        this.maxTitleChars = this.config.getInt(this.configPath + ".max-title-chars", 30);
        this.maxPages = this.config.getInt(this.configPath + ".max-pages", 100);
        this.maxItemSize = this.config.getInt(this.configPath + ".max-item-size", 56000);
        this.maxInventorySize = this.config.getInt(this.configPath + ".max-inventory-size", 2050000);
        this.itemSizeCacheMillis = (long)Math.max(1, this.config.getInt(this.configPath + ".dropped-items-size-cache-ticks", 120, "How long in ticks a dropped item's size should be cached after\nchecking.")) * 50L;
        this.inventorySizeCacheMillis = (long)Math.max(1, this.config.getInt(this.configPath + ".player-inventory-size-cache-ticks", 20, "How long in ticks a player's inventory size should be cached after\nchecking.")) * 50L;
    }

    @Override
    public void enable() {
        this.cachedItemSizes = Caffeine.newBuilder().expireAfterWrite(Duration.ofMillis(this.itemSizeCacheMillis)).build();
        this.cachedInventorySizes = Caffeine.newBuilder().expireAfterWrite(Duration.ofMillis(this.inventorySizeCacheMillis)).build();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.cachedItemSizes != null) {
            this.cachedItemSizes.invalidateAll();
            this.cachedItemSizes.cleanUp();
            this.cachedItemSizes = null;
        }
        if (this.cachedInventorySizes != null) {
            this.cachedInventorySizes.invalidateAll();
            this.cachedInventorySizes.cleanUp();
            this.cachedInventorySizes = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onBookEdit(PlayerEditBookEvent event) {
        BookMeta meta = event.getNewBookMeta();
        if (meta.hasPages() && meta.getPages().size() > this.maxPages || meta.hasAuthor() && meta.getAuthor().length() > this.maxAuthorChars || meta.hasTitle() && meta.getTitle().length() > this.maxTitleChars) {
            event.setCancelled(true);
            return;
        }
        if (ItemUtil.getApproximateByteSize(meta, this.useUTF16) > this.maxBookSize) {
            event.setCancelled(true);
            if (this.kickOnBigBook) {
                Player player = event.getPlayer();
                player.kickPlayer(AnarchyExploitFixes.translation((String)player.getLocale()).misc_MaskedKickMessage);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onItemSpawn(ItemSpawnEvent event) {
        Item item = event.getEntity();
        Integer itemSize = this.cachedItemSizes.get(item.getUniqueId(), k -> ItemUtil.getApproximateByteSize(item.getItemStack(), this.useUTF16));
        if (itemSize > this.maxItemSize) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerAttemptPickupItem(PlayerAttemptPickupItemEvent event) {
        Item item = event.getItem();
        Integer itemSize = this.cachedItemSizes.get(item.getUniqueId(), k -> ItemUtil.getApproximateByteSize(item.getItemStack(), this.useUTF16));
        if (itemSize > this.maxItemSize) {
            event.setCancelled(true);
            return;
        }
        Player player = event.getPlayer();
        if (itemSize + this.cachedInventorySizes.get(player.getUniqueId(), k -> ItemUtil.getApproximateByteSize((Iterable<ItemStack>)player.getInventory(), this.useUTF16)) > this.maxInventorySize) {
            event.setCancelled(true);
        }
    }

    private void sanitizeInventory(Iterable<ItemStack> inventory) {
        for (ItemStack item : inventory) {
            if (ItemUtil.getApproximateByteSize(item, this.useUTF16) <= this.maxItemSize) continue;
            item.setAmount(0);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    private void onJoin(PlayerJoinEvent event) {
        this.sanitizeInventory((Iterable<ItemStack>)event.getPlayer().getInventory());
    }

    @EventHandler(priority=EventPriority.LOW)
    private void onLeave(PlayerQuitEvent event) {
        this.sanitizeInventory((Iterable<ItemStack>)event.getPlayer().getInventory());
    }

    @EventHandler(priority=EventPriority.LOW)
    private void onKick(PlayerKickEvent event) {
        this.sanitizeInventory((Iterable<ItemStack>)event.getPlayer().getInventory());
    }
}

