/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.patches;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.modules.AEFModule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.NumberConversions;

public class RemoteItemPickup
extends AEFModule
implements Listener {
    private final long checkPeriodTicks;
    private final double maxItemDistance;
    private final double maxVehicleDistance;
    private final boolean kickPlayer;
    private final boolean log;
    private Map<UUID, BukkitTask> playerCheckTasks;

    public RemoteItemPickup() {
        super("patches.remote-item-pickup-exploit", false, "EXPERIMENTAL!\nAttempts to patch an exploit where players are able to expand their own\nhitbox, leading to them being able to pick up items at remote locations.\nNOTE: This isn't entirely verified yet. Any feedback is appreciated.");
        this.log = this.config.getBoolean(this.configPath + ".log", true);
        this.maxItemDistance = NumberConversions.square((double)this.config.getDouble(this.configPath + ".max-item-distance", 8.0));
        this.maxVehicleDistance = NumberConversions.square((double)this.config.getDouble(this.configPath + ".max-vehicle-distance", 8.0));
        this.checkPeriodTicks = this.config.getLong(this.configPath + ".check-period-ticks", 40L);
        this.kickPlayer = this.config.getBoolean(this.configPath + ".kick-player", true, "Kicks player if their hitbox is detected as too large.");
    }

    @Override
    public void enable() {
        this.playerCheckTasks = new HashMap<UUID, BukkitTask>();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.playerCheckTasks != null) {
            this.playerCheckTasks.values().forEach(BukkitTask::cancel);
            this.playerCheckTasks.clear();
            this.playerCheckTasks = null;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void on(PlayerQuitEvent event) {
        if (this.playerCheckTasks.containsKey(event.getPlayer().getUniqueId())) {
            this.playerCheckTasks.get(event.getPlayer().getUniqueId()).cancel();
            this.playerCheckTasks.remove(event.getPlayer().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void on(PlayerKickEvent event) {
        if (this.playerCheckTasks.containsKey(event.getPlayer().getUniqueId())) {
            this.playerCheckTasks.get(event.getPlayer().getUniqueId()).cancel();
            this.playerCheckTasks.remove(event.getPlayer().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void on(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.playerCheckTasks.compute(player.getUniqueId(), (uuid, checkTask) -> {
            if (checkTask != null) {
                checkTask.cancel();
            }
            return this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, () -> this.check(player), 10L, this.checkPeriodTicks);
        });
    }

    private void check(Player player) {
        if (player.getVehicle() == null) {
            return;
        }
        double vehicleDistanceSquared = player.getLocation().distanceSquared(player.getVehicle().getLocation());
        if (vehicleDistanceSquared <= this.maxVehicleDistance) {
            return;
        }
        player.leaveVehicle();
        if (this.log) {
            this.warn("Player " + player.getName() + " tried to ride a vehicle " + Math.sqrt(vehicleDistanceSquared) + " blocks away. (VehicleType=" + player.getVehicle().getType() + ")");
        }
        if (this.kickPlayer) {
            player.kickPlayer(AnarchyExploitFixes.translation((CommandSender)player).misc_MaskedKickMessage);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void on(PlayerAttemptPickupItemEvent event) {
        double itemDistanceSquared = event.getPlayer().getLocation().distanceSquared(event.getItem().getLocation());
        if (itemDistanceSquared > this.maxItemDistance) {
            event.setCancelled(true);
            event.getPlayer().leaveVehicle();
            if (this.log) {
                this.warn("Player " + event.getPlayer().getName() + " tried to pickup an item " + Math.sqrt(itemDistanceSquared) + " blocks away from themselves.");
            }
            if (this.kickPlayer) {
                event.getPlayer().kickPlayer(AnarchyExploitFixes.translation((CommandSender)event.getPlayer()).misc_MaskedKickMessage);
            }
        }
        if (event.getPlayer().getVehicle() == null) {
            return;
        }
        double vehicleDistanceSquared = event.getPlayer().getLocation().distanceSquared(event.getPlayer().getVehicle().getLocation());
        if (vehicleDistanceSquared > this.maxVehicleDistance) {
            if (this.log) {
                this.warn("Player " + event.getPlayer().getName() + " tried to pickup an item " + Math.sqrt(itemDistanceSquared) + " blocks away from their vehicle.(VehicleType=" + event.getPlayer().getVehicle().getType() + ")");
            }
            event.setCancelled(true);
            event.getPlayer().leaveVehicle();
            if (this.kickPlayer) {
                event.getPlayer().kickPlayer(AnarchyExploitFixes.translation((CommandSender)event.getPlayer()).misc_MaskedKickMessage);
            }
        }
    }
}

