/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.patches.commandsign;

import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.modules.patches.commandsign.SignCommandListener;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class CommandSign
extends AEFModule
implements Listener {
    private final Listener signCommandListener = SignCommandListener.isSupported() ? new SignCommandListener() : this;

    public CommandSign() {
        super("patches.prevent-command-sign", true, "Patch signs that have run_command NBT tags attached, allowing the \nto run a command with operator permissions on click. \nRecommended to enable if you had a rogue admin or backdoor incident.");
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents(this.signCommandListener, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this.signCommandListener);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!MaterialUtil.SIGNS.get().contains(event.getClickedBlock().getType())) {
            return;
        }
        if (!AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getPlayer(), AEFPermission.BYPASS_PREVENTION_COMMANDSIGN.node()).toBoolean()) {
            event.setCancelled(true);
        }
    }
}

