/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.patches.crashexploits;

import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.LocationUtil;
import me.xginko.aef.utils.WorldUtil;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.plugin.Plugin;

public class DispenserCrash
extends AEFModule
implements Listener {
    private final boolean logIsEnabled;

    public DispenserCrash() {
        super("patches.prevent-dispenser-crash", true, "Prevents dispensers from crashing the server when dispensing\nitems out of bounds: https://www.youtube.com/watch?v=XL17P87O6xA");
        this.logIsEnabled = this.config.getBoolean(this.configPath + ".log", false);
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onDispense(BlockDispenseEvent event) {
        World world = event.getBlock().getWorld();
        if (event.getBlock().getY() >= world.getMaxHeight() - 1 || event.getBlock().getY() <= WorldUtil.getMinWorldHeight(world)) {
            event.setCancelled(true);
            if (this.logIsEnabled) {
                this.info("Prevented a dispenser from crashing the server at: " + LocationUtil.toString(event.getBlock().getLocation()));
            }
        }
    }
}

