/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.patches.crashexploits;

import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.LocationUtil;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.plugin.Plugin;

public class EndGatewayCrash
extends AEFModule
implements Listener {
    private final boolean logIsEnabled;

    public EndGatewayCrash() {
        super("patches.prevent-end-gateway-crash", true, "Prevents a crash exploit involving boats and end gateways:\nhttps://www.youtube.com/watch?v=c5nVBQeYo-I");
        this.logIsEnabled = this.config.getBoolean(this.configPath + ".log", true);
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntityTeleportEvent(EntityTeleportEvent event) {
        if (event.getEntity().getWorld().getEnvironment() == World.Environment.THE_END && !event.getEntity().isEmpty()) {
            event.setCancelled(true);
            if (this.logIsEnabled) {
                this.info("Prevented " + event.getEntityType() + " from going through end gateway at " + LocationUtil.toString(event.getFrom()));
            }
        }
    }
}

