/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.patches.crashexploits;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.LocationUtil;
import me.xginko.aef.utils.MaterialUtil;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.plugin.Plugin;

public class RedstoneOnTrapdoorCrash
extends AEFModule
implements Listener {
    private final long cacheTimeMillis;
    private final int trapdoorActivationLimit;
    private final boolean logIsEnabled;
    private Cache<Location, AtomicInteger> trapdoorActivationCache;

    public RedstoneOnTrapdoorCrash() {
        super("patches.prevent-redstone-on-trapdoor-crash", true, "prevents a powerful crash exploit present in 1.13 - 1.19.3");
        this.logIsEnabled = this.config.getBoolean(this.configPath + ".log", true);
        this.trapdoorActivationLimit = this.config.getInt(this.configPath + ".max-trapdoor-activations-by-redstone-per-time", 10);
        this.cacheTimeMillis = (long)Math.max(1, this.config.getInt(this.configPath + ".time-in-ticks", 30, "1 sec = 20 ticks")) * 50L;
    }

    @Override
    public void enable() {
        this.trapdoorActivationCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofMillis(this.cacheTimeMillis)).build();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.trapdoorActivationCache != null) {
            this.trapdoorActivationCache.invalidateAll();
            this.trapdoorActivationCache.cleanUp();
            this.trapdoorActivationCache = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onRedstonePowerTrapdoor(BlockRedstoneEvent event) {
        if (!MaterialUtil.TRAPDOORS.get().contains(event.getBlock().getType())) {
            return;
        }
        Location trapdoorLoc = event.getBlock().getLocation();
        if (this.trapdoorActivationCache.get(trapdoorLoc, k -> new AtomicInteger()).incrementAndGet() > this.trapdoorActivationLimit) {
            event.getBlock().setType(XMaterial.AIR.get());
            if (this.logIsEnabled) {
                this.info("Prevented potential trapdoor crash at " + LocationUtil.toString(trapdoorLoc));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onBlockPlace(BlockPlaceEvent event) {
        if (event.getBlock() == null || !MaterialUtil.REDSTONE.get().contains(event.getBlock().getType())) {
            return;
        }
        if (MaterialUtil.TRAPDOORS.get().contains(event.getBlock().getRelative(BlockFace.DOWN).getType())) {
            event.setCancelled(true);
            if (this.logIsEnabled) {
                this.info("Prevented potential trapdoor crash at " + LocationUtil.toString(event.getBlock().getLocation()));
            }
        }
    }
}

