/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.patches.crashexploits;

import java.time.Duration;
import java.util.UUID;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.LocationUtil;
import me.xginko.aef.utils.models.ExpiringSet;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.plugin.Plugin;

public class WorldChangeCrash
extends AEFModule
implements Listener {
    private final long worldChangeDelayMillis;
    private final boolean logIsEnabled;
    private ExpiringSet<UUID> recentWorldChangers;

    public WorldChangeCrash() {
        super("patches.prevent-fast-world-teleport-crash", true, "Prevents crash methods that involve very fast teleporting\nbetween different worlds in a short time.");
        this.worldChangeDelayMillis = Math.max(1, this.config.getInt(this.configPath + ".teleport-delay-millis", 1000, "Time in milliseconds until an entity can teleport to\nanother world again."));
        this.logIsEnabled = this.config.getBoolean(this.configPath + ".log", false);
    }

    @Override
    public void enable() {
        this.recentWorldChangers = new ExpiringSet(Duration.ofMillis(this.worldChangeDelayMillis));
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.recentWorldChangers != null) {
            this.recentWorldChangers.clear();
            this.recentWorldChangers.cleanUp();
            this.recentWorldChangers = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onTeleport(EntityTeleportEvent event) {
        if (event.getTo() == null) {
            return;
        }
        if (event.getFrom().getWorld().getUID().equals(event.getTo().getWorld().getUID())) {
            return;
        }
        if (this.recentWorldChangers.contains(event.getEntity().getUniqueId())) {
            event.setCancelled(true);
            if (this.logIsEnabled) {
                this.info("Cancelled too fast world teleport of entity: " + event.getEntityType().name() + " at " + LocationUtil.toString(event.getFrom()));
            }
        } else {
            this.recentWorldChangers.add(event.getEntity().getUniqueId());
        }
    }
}

