/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.preventions;

import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.modules.AEFModule;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.NumberConversions;

public class BedTrap
extends AEFModule
implements Listener {
    private final long timeInSeconds;
    private final double maxBedDistanceSquared;
    private final int maxDeathsPerTime;
    private final boolean logIsEnabled;
    private Cache<UUID, AtomicInteger> playerDeathNearBedCount;

    public BedTrap() {
        super("preventions.anti-bed-trap", false, "Resets a players bed respawn they die too many times within\na certain timeframe.");
        this.logIsEnabled = this.config.getBoolean(this.configPath + ".log", false);
        this.maxDeathsPerTime = this.config.getInt(this.configPath + ".max-deaths-per-time", 7, "Amount of times player can die until he is determined as bed-trapped.");
        this.timeInSeconds = Math.max(1, this.config.getInt(this.configPath + ".time-in-seconds", 5, "Time until death counter will be reset again"));
        this.maxBedDistanceSquared = NumberConversions.square((double)this.config.getDouble(this.configPath + ".max-distance-from-bed", 6.0));
    }

    @Override
    public void enable() {
        this.playerDeathNearBedCount = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(this.timeInSeconds)).build();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.playerDeathNearBedCount != null) {
            this.playerDeathNearBedCount.invalidateAll();
            this.playerDeathNearBedCount.cleanUp();
            this.playerDeathNearBedCount = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onDeath(PlayerDeathEvent event) {
        if (!this.isNearBedSpawn(event.getEntity())) {
            return;
        }
        if (this.playerDeathNearBedCount.get(event.getEntity().getUniqueId(), k -> new AtomicInteger()).incrementAndGet() > this.maxDeathsPerTime) {
            event.getEntity().setBedSpawnLocation(null, true);
            if (this.logIsEnabled) {
                this.info("Reset bed respawn of potentially bed-trapped player '" + event.getEntity().getName() + "'");
            }
        }
    }

    private boolean isNearBedSpawn(Player player) {
        Location bedSpawn = player.getBedSpawnLocation();
        if (bedSpawn == null) {
            return false;
        }
        if (!player.getWorld().getUID().equals(bedSpawn.getWorld().getUID())) {
            return false;
        }
        return player.getLocation().distanceSquared(bedSpawn) > this.maxBedDistanceSquared;
    }
}

