/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.preventions;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.LocationUtil;
import org.bukkit.GameMode;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class IllegalGameMode
extends AEFModule
implements Runnable,
Listener {
    private final Map<String, GameMode> worldSettings;
    private final Set<String> allowedGamemodePlayers;
    private final GameMode defaultGamemode;
    private final long checkPeriodTicks;
    private final boolean shouldLog;
    private BukkitTask scheduledCheck;

    public IllegalGameMode() {
        super("preventions.illegal-gamemode", false, "Forces GameMode for players not in the whitelist.\nUseful protection against past and future backdoor incidents.");
        GameMode gameMode;
        this.shouldLog = this.config.getBoolean(this.configPath + ".log", true);
        this.checkPeriodTicks = this.config.getLong(this.configPath + ".check-period-ticks", 200L, "How often to (asynchronously) check all online players\nfor illegal GameMode in ticks (1 sec = 20 ticks).");
        String configuredGamemode = this.config.getString(this.configPath + ".default-gamemode", GameMode.SURVIVAL.name(), "GameModes: " + Arrays.stream(GameMode.values()).map(Enum::name).collect(Collectors.joining(", ")));
        try {
            gameMode = GameMode.valueOf((String)configuredGamemode);
        }
        catch (IllegalArgumentException e) {
            this.notRecognized(GameMode.class, configuredGamemode);
            gameMode = GameMode.SURVIVAL;
        }
        this.defaultGamemode = gameMode;
        HashMap<String, Object> defaults = new HashMap<String, Object>(3);
        defaults.put("world", GameMode.SURVIVAL.name());
        defaults.put("world_nether", GameMode.SURVIVAL.name());
        defaults.put("world_the_end", GameMode.SURVIVAL.name());
        ConfigSection section = this.config.getConfigSection(this.configPath + ".world-gamemodes", defaults);
        List<String> worlds = section.getKeys(false);
        this.worldSettings = new HashMap<String, GameMode>(worlds.size());
        for (String world : worlds) {
            try {
                this.worldSettings.put(world, GameMode.valueOf((String)section.getString(world)));
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(GameMode.class, world);
            }
        }
        this.allowedGamemodePlayers = new HashSet<String>(this.config.getList(this.configPath + ".whitelisted-players", Collections.singletonList("Notch")));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.scheduledCheck = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, (Runnable)this, 1L, this.checkPeriodTicks);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.scheduledCheck != null) {
            this.scheduledCheck.cancel();
            this.scheduledCheck = null;
        }
    }

    @Override
    public void run() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.checkForIllegalGameMode((HumanEntity)player);
        }
    }

    private void checkForIllegalGameMode(HumanEntity player) {
        if (this.allowedGamemodePlayers.contains(player.getName())) {
            return;
        }
        GameMode targetGamemode = this.worldSettings.getOrDefault(player.getWorld().getName(), this.defaultGamemode);
        if (player.getGameMode() == targetGamemode) {
            return;
        }
        if (this.shouldLog) {
            this.warn(player.getName() + " is GameMode " + player.getGameMode().name() + " at " + LocationUtil.toString(player.getLocation()) + ". Setting to " + targetGamemode.name());
        }
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> player.setGameMode(targetGamemode));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onGameModeChange(PlayerGameModeChangeEvent event) {
        if (this.allowedGamemodePlayers.contains(event.getPlayer().getName())) {
            return;
        }
        if (event.getNewGameMode() != this.worldSettings.getOrDefault(event.getPlayer().getWorld().getName(), this.defaultGamemode)) {
            if (this.shouldLog) {
                this.warn(event.getPlayer().getName() + " tried to change to GameMode " + event.getNewGameMode().name() + " at " + LocationUtil.toString(event.getPlayer().getLocation()));
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onJoin(PlayerJoinEvent event) {
        this.checkForIllegalGameMode((HumanEntity)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onChangedWorld(PlayerChangedWorldEvent event) {
        this.checkForIllegalGameMode((HumanEntity)event.getPlayer());
    }
}

