/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.preventions;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.LocationUtil;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class IllegalPermissions
extends AEFModule
implements Runnable,
Listener {
    private final List<String> commandsOnDetection;
    private final Set<String> allowedOperators;
    private final Set<String> blacklistedPermissions;
    private final long checkPeriodTicks;
    private final boolean shouldLog;
    private BukkitTask scheduledCheck;

    public IllegalPermissions() {
        super("preventions.illegal-permissions", false, "Takes action against players found with unauthorized permissions.\nUseful protection against past and future backdoor incidents");
        this.shouldLog = this.config.getBoolean(this.configPath + ".log", true);
        this.checkPeriodTicks = this.config.getLong(this.configPath + ".check-period-ticks", 200L, "Because there isn't really an event we can use to track, whether\na player has somehow acquired illegal permissions, we also\n(asynchronously) check all players every x ticks (1 sec = 20 ticks).");
        this.allowedOperators = new HashSet<String>(this.config.getList(this.configPath + ".whitelisted-players", Collections.singletonList("Notch")));
        this.blacklistedPermissions = new HashSet<String>(this.config.getList(this.configPath + ".blacklisted-permissions", Collections.singletonList("*")));
        this.commandsOnDetection = this.config.getList(this.configPath + ".commands-on-detect", Collections.singletonList("ban %player%"));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.scheduledCheck = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, (Runnable)this, 1L, this.checkPeriodTicks);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.scheduledCheck != null) {
            this.scheduledCheck.cancel();
            this.scheduledCheck = null;
        }
    }

    private void checkForIllegalPermissions(Player player) {
        if (this.allowedOperators.contains(player.getName())) {
            return;
        }
        if (player.isOp()) {
            if (this.shouldLog) {
                this.warn(player.getName() + " was found with illegal server operator status at " + LocationUtil.toString(player.getLocation()));
            }
            player.setOp(false);
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                for (String command : this.commandsOnDetection) {
                    this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), command.replace("%player%", player.getName()));
                }
            });
            return;
        }
        for (String permission : this.blacklistedPermissions) {
            if (!AnarchyExploitFixes.permissions().permissionValue((Permissible)player, permission).toBoolean()) continue;
            if (this.shouldLog) {
                this.warn(player.getName() + " was found with illegal permission: '" + permission + "' at " + LocationUtil.toString(player.getLocation()));
            }
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                for (String command : this.commandsOnDetection) {
                    this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), command.replace("%player%", player.getName()));
                }
            });
            return;
        }
    }

    @Override
    public void run() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.checkForIllegalPermissions(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onJoin(PlayerJoinEvent event) {
        this.checkForIllegalPermissions(event.getPlayer());
    }
}

