/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.preventions;

import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class MapSpam
extends AEFModule
implements Listener {
    private final long cooldownMillis;
    private final int mapCreateLimit;
    private final boolean shouldNotifyPlayers;
    private Cache<UUID, MapCreations> trackedPlayers;

    public MapSpam() {
        super("preventions.prevent-map-reset-spam", false, "Puts a cooldown on creating maps so players cant reset\nmap arts that easily.\nOnly needed on versions below 1.12 and lower.\nBypass permission: " + AEFPermission.BYPASS_MAP_SPAM.node());
        this.shouldNotifyPlayers = this.config.getBoolean(this.configPath + ".notify-players", true, "Sends a message to players telling them how many maps\nthey can create per time");
        this.cooldownMillis = TimeUnit.MINUTES.toMillis(Math.max(1, this.config.getInt(this.configPath + ".cooldown-time-in-minutes", 60)));
        this.mapCreateLimit = this.config.getInt(this.configPath + ".max-amount-of-maps-per-time", 4);
    }

    @Override
    public void enable() {
        this.trackedPlayers = Caffeine.newBuilder().expireAfterWrite(Duration.ofMillis(this.cooldownMillis)).build();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.trackedPlayers != null) {
            this.trackedPlayers.invalidateAll();
            this.trackedPlayers.cleanUp();
            this.trackedPlayers = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    private void onPlayerInteract(PlayerInteractEvent event) {
        int remaining;
        if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) {
            return;
        }
        ItemStack mapItem = event.getItem();
        if (mapItem == null || mapItem.getType() != XMaterial.MAP.get()) {
            return;
        }
        Player player = event.getPlayer();
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getPlayer(), AEFPermission.BYPASS_MAP_SPAM.node()).toBoolean()) {
            return;
        }
        MapCreations mapCreations = this.trackedPlayers.get(player.getUniqueId(), k -> new MapCreations());
        long currentTime = System.currentTimeMillis();
        long millisBetweenPrevMapCreateAndNow = currentTime - mapCreations.lastCreateTime.getAndSet(currentTime);
        int mapsCreated = mapCreations.count.getAndIncrement();
        if (mapsCreated >= this.mapCreateLimit) {
            event.setCancelled(true);
            player.updateInventory();
            if (this.shouldNotifyPlayers) {
                player.sendMessage(AnarchyExploitFixes.translation((String)player.getLocale()).mapspam_exceededLimit.replace("%time%", MapSpam.toHumanTime(this.cooldownMillis - millisBetweenPrevMapCreateAndNow)));
            }
            return;
        }
        if (this.shouldNotifyPlayers && (remaining = this.mapCreateLimit - mapsCreated) > 0) {
            player.sendMessage(AnarchyExploitFixes.translation((String)player.getLocale()).mapspam_youCanOnlyCreateXMoreMaps.replace("%amount%", Integer.toString(remaining)).replace("%time%", MapSpam.toHumanTime(this.cooldownMillis - millisBetweenPrevMapCreateAndNow)));
        }
    }

    private static String toHumanTime(long milliseconds) {
        Duration duration = Duration.ofMillis(milliseconds);
        if (duration.isNegative()) {
            duration = duration.negated();
        }
        int seconds = (int)(duration.getSeconds() % 60L);
        int minutes = (int)(duration.toMinutes() % 60L);
        int hours = (int)(duration.toHours() % 24L);
        if (hours > 0) {
            return String.format("%02dh %02dm %02ds", hours, minutes, seconds);
        }
        if (minutes > 0) {
            return String.format("%02dm %02ds", minutes, seconds);
        }
        return String.format("%02ds", seconds);
    }

    private static class MapCreations {
        public AtomicLong lastCreateTime = new AtomicLong(System.currentTimeMillis());
        public AtomicInteger count = new AtomicInteger(1);
    }
}

