/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.preventions.blockbreak;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.MaterialUtil;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.Plugin;

public class PistonExplodePermBlockRemoval
extends AEFModule
implements Listener {
    private final Set<String> whitelistedWorlds;

    public PistonExplodePermBlockRemoval() {
        super("preventions.permanent-block-breaking.by-exploding-pistons", true);
        this.whitelistedWorlds = new HashSet<String>(this.config.getList(this.configPath + ".whitelisted-worlds", Collections.singletonList("example_world_name")));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntityExplode(EntityExplodeEvent event) {
        if (this.whitelistedWorlds.contains(event.getEntity().getWorld().getName())) {
            return;
        }
        HashSet pistons_that_could_break_indestructible_blocks = new HashSet();
        event.blockList().removeIf(block -> {
            if (!MaterialUtil.PISTONS.get().contains(block.getType())) {
                return false;
            }
            for (BlockFace face : BlockFace.values()) {
                if (!MaterialUtil.INDESTRUCTIBLES.get().contains(block.getRelative(face).getType())) continue;
                pistons_that_could_break_indestructible_blocks.add(block);
                return true;
            }
            return false;
        });
        if (pistons_that_could_break_indestructible_blocks.isEmpty()) {
            return;
        }
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> pistons_that_could_break_indestructible_blocks.forEach(block -> block.setType(XMaterial.AIR.get())), 5L);
    }
}

