/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.preventions.portals;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.LocationUtil;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.MathUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.plugin.Plugin;

public class EndPortalDestruction
extends AEFModule
implements Listener {
    private final Set<Location> pillars;
    private final double endBedrockProtectRadiusSquared;
    private final boolean logIsEnabled;

    public EndPortalDestruction() {
        super("preventions.portals.prevent-destroying-end-portals", true);
        this.logIsEnabled = this.config.getBoolean(this.configPath + ".log", true);
        this.endBedrockProtectRadiusSquared = MathUtil.square(this.config.getInt(this.configPath + ".end.bedrock-protection-radius-blocks", 8));
        this.pillars = this.config.getList(this.configPath + ".end.pillar-blocks", Arrays.asList("world_the_end:143:140:-50", "world_the_end:112:90:-90"), "Add block locations that should be protected as well. \nFormat: <worldname>:<x>:<y>:<z> \nIf you don't want to use this, just configure an empty list: \npillar-blocks: []").stream().map(entry -> {
            String[] location = entry.split(":");
            try {
                return new Location(this.plugin.getServer().getWorld(location[0]), (double)Integer.parseInt(location[1]), (double)Integer.parseInt(location[2]), (double)Integer.parseInt(location[3])).toBlockLocation();
            }
            catch (NumberFormatException e) {
                this.notRecognized(Integer.class, (String)entry);
                return null;
            }
            catch (NullPointerException e) {
                this.warn("Failed to parse location '" + entry + "'. Is the world name correct and the proper format being used?");
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onBlockDispense(BlockDispenseEvent event) {
        if (MaterialUtil.BLOCK_DISPENSE_BUCKETS.get().contains(event.getItem().getType()) && this.isNearEndPortal(event.getBlock())) {
            event.setCancelled(true);
            if (this.logIsEnabled) {
                this.info("Prevented a dispenser from destroying an end portal!");
            }
        }
    }

    private boolean isNearEndPortal(Block dispenser) {
        for (BlockFace face : BlockFace.values()) {
            if (dispenser.getRelative(face).getType() != XMaterial.END_PORTAL.get()) continue;
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerBucketEvent(PlayerBucketEmptyEvent event) {
        if (event.getBlockClicked().getRelative(event.getBlockFace()).getType() == XMaterial.END_PORTAL.get()) {
            event.setCancelled(true);
            if (this.logIsEnabled) {
                this.info("Prevented " + event.getPlayer().getName() + " from destroying an end portal!");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPistonRetract(BlockPistonRetractEvent event) {
        Block block_that_could_get_removed = event.getBlock().getRelative(event.getDirection().getOppositeFace());
        if (this.isEndPortal(block_that_could_get_removed.getType()) || this.pillars.contains(block_that_could_get_removed.getLocation()) || this.isWithinEndProtectedRadius(block_that_could_get_removed.getLocation())) {
            event.setCancelled(true);
            if (this.logIsEnabled) {
                this.info("Prevented piston from destroying an end portal!");
            }
            return;
        }
        for (BlockFace blockFace : BlockFace.values()) {
            if (!this.isEndPortal(block_that_could_get_removed.getRelative(blockFace).getType()) && !this.isEndPortal(block_that_could_get_removed.getRelative(blockFace, 2).getType()) && !this.isWithinEndProtectedRadius(block_that_could_get_removed.getLocation())) continue;
            event.setCancelled(true);
            if (this.logIsEnabled) {
                this.info("Prevented piston from destroying an end portal!");
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPistonExplode(EntityExplodeEvent event) {
        HashSet pistons_that_could_remove_protected = new HashSet();
        event.blockList().removeIf(block -> {
            if (MaterialUtil.PISTONS.get().contains(block.getType())) {
                for (BlockFace face : BlockFace.values()) {
                    if (!this.isEndPortal(block.getRelative(face).getType()) && !this.isEndPortal(block.getRelative(face, 2).getType()) && !this.pillars.contains(block.getRelative(face).getLocation()) && !this.isWithinEndProtectedRadius(block.getLocation())) continue;
                    pistons_that_could_remove_protected.add(block);
                    return true;
                }
            }
            return false;
        });
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> pistons_that_could_remove_protected.forEach(block -> block.setType(XMaterial.AIR.get())), 5L);
    }

    private boolean isWithinEndProtectedRadius(Location location) {
        if (!location.getWorld().getEnvironment().equals((Object)World.Environment.THE_END)) {
            return false;
        }
        return LocationUtil.getSquaredDistance2DTo00(location) <= this.endBedrockProtectRadiusSquared;
    }

    private boolean isEndPortal(Material material) {
        return material == XMaterial.END_PORTAL.get() || material == XMaterial.END_PORTAL_FRAME.get();
    }
}

