/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.preventions.portals;

import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.libs.xseries.XSound;
import me.xginko.aef.modules.AEFModule;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.plugin.Plugin;

public class PreventPortalTraps
extends AEFModule
implements Listener {
    private final long tpBackDelay;

    public PreventPortalTraps() {
        super("preventions.portals.prevent-portal-traps", false, "Teleports a player back to the original location if they have been\nstanding in a portal for too long.");
        this.tpBackDelay = (long)this.config.getInt(this.configPath + ".wait-time-until-tp-back-in-seconds", 10) * 20L;
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPortal(PlayerPortalEvent event) {
        Player player = event.getPlayer();
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            if (player.getLocation().getBlock().getType() == XMaterial.NETHER_PORTAL.get()) {
                player.teleport(event.getFrom());
                player.playSound(player.getLocation(), (Sound)XSound.BLOCK_PORTAL_TRAVEL.get(), 1.0f, 1.0f);
            }
        }, this.tpBackDelay);
    }
}

