/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.preventions.portals;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.libs.xseries.base.XBase;
import me.xginko.aef.modules.AEFModule;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.plugin.Plugin;

public class PreventSpecificEntitiesInPortals
extends AEFModule
implements Listener {
    private final Set<EntityType> forbiddenTypes;

    public PreventSpecificEntitiesInPortals() {
        super("preventions.portals.prevent-specific-types", true, "Configure entities here that you suspect might be used in a dupe \nwith portals. \nCAUTION: Will kill the entity on folia due to broken portal event. \nThere is sadly no other efficient way.");
        List<String> defaults = Stream.of(XEntityType.ITEM, XEntityType.FIREWORK_ROCKET, XEntityType.TNT, XEntityType.EXPERIENCE_BOTTLE, XEntityType.EXPERIENCE_ORB, XEntityType.ARMOR_STAND).filter(XBase::isSupported).map(XEntityType::get).map(Enum::name).collect(Collectors.toList());
        this.forbiddenTypes = this.config.getList(this.configPath + ".entities", defaults, "Defaults prevent common lag methods.").stream().map(configuredType -> {
            try {
                return EntityType.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(EntityType.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(EntityType.class)));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPortal(EntityPortalEvent event) {
        if (this.forbiddenTypes.contains(event.getEntityType())) {
            event.setCancelled(true);
        }
    }
}

