/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.preventions.withers;

import java.time.Duration;
import java.util.UUID;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.models.ExpiringSet;
import org.bukkit.entity.Wither;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.plugin.Plugin;

public class RateLimitWitherSkulls
extends AEFModule
implements Listener {
    private final long playerCooldownMillis;
    private final long otherCooldownMillis;
    private final long notargetCooldownMillis;
    private ExpiringSet<UUID> targetingPlayers;
    private ExpiringSet<UUID> targetingOther;
    private ExpiringSet<UUID> notTargeting;

    public RateLimitWitherSkulls() {
        super("preventions.withers.rate-limit-shooting-skulls", false, "This can help combat lag caused by a ton of wither skulls\nspawning but weakens withers.");
        this.playerCooldownMillis = (long)Math.max(1, this.config.getInt(this.configPath + ".player-target-cooldown-in-ticks", 20, "Cooldown until another skull will be shot at a player")) * 50L;
        this.otherCooldownMillis = (long)Math.max(1, this.config.getInt(this.configPath + ".other-target-cooldown-in-ticks", 40, "Cooldown until another skull can be shot at anything \nelse other than a player.")) * 50L;
        this.notargetCooldownMillis = (long)Math.max(1, this.config.getInt(this.configPath + ".no-target-cooldown-in-ticks", 100, "Cooldown when wither has no target")) * 50L;
    }

    @Override
    public void enable() {
        this.targetingPlayers = new ExpiringSet(Duration.ofMillis(this.playerCooldownMillis));
        this.targetingOther = new ExpiringSet(Duration.ofMillis(this.otherCooldownMillis));
        this.notTargeting = new ExpiringSet(Duration.ofMillis(this.notargetCooldownMillis));
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.targetingPlayers != null) {
            this.targetingPlayers.clear();
            this.targetingPlayers.cleanUp();
            this.targetingPlayers = null;
        }
        if (this.targetingOther != null) {
            this.targetingOther.clear();
            this.targetingOther.cleanUp();
            this.targetingOther = null;
        }
        if (this.notTargeting != null) {
            this.notTargeting.clear();
            this.notTargeting.cleanUp();
            this.notTargeting = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onProjectileLaunch(ProjectileLaunchEvent event) {
        if (event.getEntityType() != XEntityType.WITHER_SKULL.get()) {
            return;
        }
        if (!(event.getEntity().getShooter() instanceof Wither)) {
            return;
        }
        Wither wither = (Wither)event.getEntity().getShooter();
        if (this.targetingPlayers.contains(wither.getUniqueId()) || this.targetingOther.contains(wither.getUniqueId()) || this.notTargeting.contains(wither.getUniqueId())) {
            event.setCancelled(true);
            return;
        }
        if (wither.getTarget() == null) {
            this.notTargeting.add(wither.getUniqueId());
            return;
        }
        if (wither.getTarget().getType() == XEntityType.PLAYER.get()) {
            this.targetingPlayers.add(wither.getUniqueId());
            return;
        }
        this.targetingOther.add(wither.getUniqueId());
    }
}

