/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.preventions.withers;

import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import me.xginko.aef.utils.EntityUtil;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;

public class RemoveSkullsOnChunkUnload
extends AEFModule
implements Listener {
    public RemoveSkullsOnChunkUnload() {
        super("preventions.withers.remove-flying-wither-skulls.on-chunk-unload", true, "Removes wither skulls when the chunk gets unloaded.\nUse if you have a ton of them at spawn and they are causing lag.");
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onProjectileLaunch(ProjectileLaunchEvent event) {
        if (event.getEntityType() == XEntityType.WITHER_SKULL.get()) {
            EntityUtil.setPersistent((Entity)event.getEntity(), false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onChunkUnload(ChunkUnloadEvent event) {
        if (!ChunkUtil.isEntitiesLoaded(event.getChunk())) {
            return;
        }
        for (Entity entity : event.getChunk().getEntities()) {
            if (entity.getType() != XEntityType.WITHER_SKULL.get()) continue;
            entity.remove();
        }
    }
}

