/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.preventions.withers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.LocationUtil;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.NumberConversions;

public class WitherSkullDropsAtSpawn
extends AEFModule
implements Listener {
    private final Map<String, Double> worldsAndTheirRadiuses;

    public WitherSkullDropsAtSpawn() {
        super("preventions.withers.disable-item-drops-at-spawn", false, "Prevents wither skulls from dropping items when they hit a block\nwithin a certain radius from 00. Can help with lag.");
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("world", 5000);
        defaults.put("world_nether", 5000);
        defaults.put("world_the_end", 5000);
        ConfigSection section = this.config.getConfigSection(this.configPath + ".worlds", defaults);
        List<String> worlds = section.getKeys(false);
        this.worldsAndTheirRadiuses = new HashMap<String, Double>(worlds.size());
        for (String world : worlds) {
            try {
                double radiusSquared = NumberConversions.square((double)Integer.parseInt(section.getString(world)));
                this.worldsAndTheirRadiuses.put(world, radiusSquared);
            }
            catch (NumberFormatException e) {
                this.warn("Radius for world '" + world + "' is not a valid integer.");
            }
        }
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntityExplode(EntityExplodeEvent event) {
        if (event.getEntityType() != XEntityType.WITHER_SKULL.get()) {
            return;
        }
        if (!this.worldsAndTheirRadiuses.containsKey(event.getLocation().getWorld().getName())) {
            return;
        }
        if (LocationUtil.getSquaredDistance2DTo00(event.getLocation()) <= this.worldsAndTheirRadiuses.get(event.getLocation().getWorld().getName())) {
            event.setYield(0.0f);
        }
    }
}

