/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils;

import de.tr7zw.nbtapi.NBT;
import de.tr7zw.nbtapi.iface.ReadableNBT;
import java.util.EnumMap;
import java.util.Map;
import me.xginko.aef.utils.models.Lazy;
import me.xginko.aef.utils.reflection.ReflectionUtil;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Waterlogged;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockUtil {
    private static final boolean WATERLOGGED_AVAILABLE = ReflectionUtil.hasClass("org.bukkit.block.data.Waterlogged");
    private static final boolean FAST_IS_SOLID_AVAILABLE = ReflectionUtil.hasMethod(Block.class, "isSolid", new Class[0]);
    private static final Lazy<Map<Material, Boolean>> IS_WATERLOGGABLE_CACHE = Lazy.of(() -> new EnumMap(Material.class));

    public static boolean isWaterloggedAvailable() {
        return WATERLOGGED_AVAILABLE;
    }

    public static boolean isWaterlogged(@Nullable BlockState blockState) {
        return blockState != null && IS_WATERLOGGABLE_CACHE.get().computeIfAbsent(blockState.getType(), k -> blockState.getBlockData() instanceof Waterlogged) != false && ((Waterlogged)blockState.getBlockData()).isWaterlogged();
    }

    public static boolean isSolid(Block block) {
        return FAST_IS_SOLID_AVAILABLE ? block.isSolid() : block.getType().isSolid();
    }

    public static String getNBTString(@NotNull BlockState blockState) {
        return (String)NBT.get((BlockState)blockState, ReadableNBT::toString);
    }
}

