/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils;

import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.BundleContents;
import io.papermc.paper.datacomponent.item.ItemContainerContents;
import java.util.List;
import me.xginko.aef.utils.reflection.ReflectionUtil;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class DataComponentUtil {
    public static final boolean COMPONENTS_SUPPORTED = ReflectionUtil.hasClass("io.papermc.paper.datacomponent.DataComponentTypes") && ReflectionUtil.hasMethod(ItemStack.class, "getData", new Class[0]);

    public static boolean hasBundleContent(@NotNull ItemStack itemStack) {
        return itemStack.hasData((DataComponentType)DataComponentTypes.BUNDLE_CONTENTS);
    }

    @Nullable
    public static @Unmodifiable List<ItemStack> getBundleContent(@NotNull ItemStack itemStack) {
        BundleContents bundleContents;
        if (DataComponentUtil.hasBundleContent(itemStack) && (bundleContents = (BundleContents)itemStack.getData(DataComponentTypes.BUNDLE_CONTENTS)) != null) {
            return bundleContents.contents();
        }
        return null;
    }

    public static boolean hasContainerContent(@NotNull ItemStack itemStack) {
        return itemStack.hasData((DataComponentType)DataComponentTypes.CONTAINER);
    }

    @Nullable
    public static @Unmodifiable List<ItemStack> getContainerContent(@NotNull ItemStack itemStack) {
        ItemContainerContents containerContents;
        if (DataComponentUtil.hasContainerContent(itemStack) && (containerContents = (ItemContainerContents)itemStack.getData(DataComponentTypes.CONTAINER)) != null) {
            return containerContents.contents();
        }
        return null;
    }
}

