/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import me.xginko.aef.utils.models.Lazy;

public final class LocaleUtil {
    public static final Pattern LANGUAGE_TAG_PATTERN = Pattern.compile("([a-z]{1,3}_[a-z]{1,3})(\\.yml)", 2);
    private static final Lazy<Map<String, Locale>> LANGTAG_LOCALE_MAP = Lazy.of(HashMap::new);

    public static Locale localeForLanguageTag(String languageTag) {
        return LANGTAG_LOCALE_MAP.get().computeIfAbsent(languageTag, tag -> {
            Locale match = Locale.forLanguageTag(tag.toLowerCase(Locale.ROOT).replace('_', '-'));
            return match == Locale.ROOT ? Locale.US : match;
        });
    }

    public static String languageTagForLocale(Locale locale) {
        return locale.toString().toLowerCase(Locale.ROOT).replace('-', '_');
    }
}

