/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils;

import me.xginko.aef.utils.MathUtil;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public final class LocationUtil {
    public static String toString(Location location) {
        return LocationUtil.jvmdowngrader$concat$toString$1(location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @NotNull
    public static Location toXZCenter(@NotNull Location location) {
        Location centered = location.clone();
        centered.setX((double)centered.getBlockX() + 0.5);
        centered.setY((double)centered.getBlockY());
        centered.setZ((double)centered.getBlockZ() + 0.5);
        return centered;
    }

    public static double getSquaredDistance2DTo00(Location location) {
        return MathUtil.square(location.getX(), location.getZ());
    }

    public static double getDistance2DTo00(Location location) {
        return MathUtil.hypot(location.getX(), location.getZ());
    }

    public static double getRelativeSquaredDistance2D(Location from, Location to) {
        double toX = to.getX();
        double toZ = to.getZ();
        double fromX = from.getX();
        double fromZ = from.getZ();
        if (to.getWorld().getEnvironment() != from.getWorld().getEnvironment()) {
            if (from.getWorld().getEnvironment() == World.Environment.NETHER) {
                fromX *= 8.0;
                fromZ *= 8.0;
            }
            if (to.getWorld().getEnvironment() == World.Environment.NETHER) {
                toX *= 8.0;
                toZ *= 8.0;
            }
        }
        return MathUtil.square(toX - fromX, toZ - fromZ);
    }

    public static double getRelativeDistance2D(Location from, Location to) {
        return MathUtil.sqrt(LocationUtil.getRelativeSquaredDistance2D(from, to));
    }

    public static double getRelativeSquaredDistance3D(Location from, Location to) {
        double toX = to.getX();
        double toZ = to.getZ();
        double fromX = from.getX();
        double fromZ = from.getZ();
        if (to.getWorld().getEnvironment() != from.getWorld().getEnvironment()) {
            if (from.getWorld().getEnvironment() == World.Environment.NETHER) {
                fromX *= 8.0;
                fromZ *= 8.0;
            }
            if (to.getWorld().getEnvironment() == World.Environment.NETHER) {
                toX *= 8.0;
                toZ *= 8.0;
            }
        }
        return MathUtil.square(toX - fromX, from.getY() - to.getY(), toZ - fromZ);
    }

    public static double getRelativeDistance3D(Location from, Location to) {
        return MathUtil.sqrt(LocationUtil.getRelativeSquaredDistance3D(from, to));
    }

    private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, int n, int n2, int n3) {
        return "[" + string + "] x=" + n + ", y=" + n2 + ", z=" + n3;
    }
}

