/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.libs.xseries.XTag;
import me.xginko.aef.libs.xseries.base.XBase;
import me.xginko.aef.utils.enums.Platform;
import me.xginko.aef.utils.models.Lazy;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.jetbrains.annotations.Nullable;

public final class MaterialUtil {
    public static final Lazy<Set<Material>> INVENTORY_HOLDERS = Lazy.of(() -> Arrays.stream(Material.values()).filter(material -> Platform.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_6) && material.isItem()).map(ItemStack::new).filter(itemStack -> itemStack.getItemMeta() instanceof BlockStateMeta).map(itemStack -> ((BlockStateMeta)itemStack.getItemMeta()).getBlockState()).filter(blockState -> blockState instanceof InventoryHolder).map(BlockState::getType).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> LECTERN_BOOKS = Lazy.of(() -> XTag.ITEMS_LECTERN_BOOKS.getValues().stream().filter(XBase::isSupported).map(XMaterial::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> CARPETS = Lazy.of(() -> XTag.CARPETS.getValues().stream().filter(XBase::isSupported).map(XMaterial::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> RAILS = Lazy.of(() -> XTag.RAILS.getValues().stream().filter(XBase::isSupported).map(XMaterial::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> SIGNS = Lazy.of(() -> XTag.SIGNS.getValues().stream().filter(XBase::isSupported).map(XMaterial::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> TRAPDOORS = Lazy.of(() -> XTag.TRAPDOORS.getValues().stream().filter(XBase::isSupported).map(XMaterial::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> SHULKER_BOXES = Lazy.of(() -> XTag.SHULKER_BOXES.getValues().stream().filter(XBase::isSupported).map(XMaterial::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> BUNDLES = Lazy.of(() -> Arrays.stream(XMaterial.values()).filter(XBase::isSupported).filter(xMaterial -> xMaterial.name().toUpperCase(Locale.ROOT).contains("BUNDLE")).map(XMaterial::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> ANVILS = Lazy.of(() -> XTag.ANVIL.getValues().stream().filter(XBase::isSupported).map(XMaterial::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> BEDS = Lazy.of(() -> XTag.BEDS.getValues().stream().filter(XBase::isSupported).map(XMaterial::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> POTIONS = Lazy.of(() -> Arrays.stream(XMaterial.values()).filter(xMaterial -> xMaterial.name().toUpperCase(Locale.ROOT).contains("POTION")).filter(XBase::isSupported).map(XMaterial::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> PISTONS = Lazy.of(() -> Arrays.stream(XMaterial.values()).filter(xMaterial -> xMaterial.name().toUpperCase(Locale.ROOT).contains("PISTON")).filter(XBase::isSupported).map(XMaterial::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> SPAWN_EGGS = Lazy.of(() -> Arrays.stream(XMaterial.values()).filter(xMaterial -> xMaterial.name().toUpperCase(Locale.ROOT).endsWith("_SPAWN_EGG")).filter(XBase::isSupported).map(XMaterial::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> SLAB_LIKE = Lazy.of(() -> Stream.concat(Arrays.stream(XMaterial.values()).filter(xMaterial -> xMaterial.name().toUpperCase(Locale.ROOT).endsWith("_SLAB")), Stream.of(XMaterial.SCULK_SENSOR, XMaterial.CALIBRATED_SCULK_SENSOR, XMaterial.SCULK_SHRIEKER)).filter(XBase::isSupported).map(XMaterial::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> PLAYER_HEADS = Lazy.of(() -> Stream.of(XMaterial.PLAYER_HEAD, XMaterial.PLAYER_WALL_HEAD).filter(XBase::isSupported).map(XMaterial::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> REDSTONE = Lazy.of(() -> Stream.of(XMaterial.REDSTONE, XMaterial.REDSTONE_WIRE).filter(XBase::isSupported).map(XMaterial::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> SINK_IN_BLOCKS = Lazy.of(() -> Stream.of(XMaterial.SOUL_SAND, XMaterial.FARMLAND, XMaterial.MUD).filter(XBase::isSupported).map(XMaterial::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> SOLID_INDESTRUCTIBLES = Lazy.of(() -> Stream.of(XMaterial.BEDROCK, XMaterial.END_PORTAL_FRAME, XMaterial.REINFORCED_DEEPSLATE, XMaterial.STRUCTURE_BLOCK, XMaterial.STRUCTURE_VOID, XMaterial.BARRIER, XMaterial.COMMAND_BLOCK).filter(XBase::isSupported).map(XMaterial::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> INDESTRUCTIBLES = Lazy.of(() -> Stream.concat(SOLID_INDESTRUCTIBLES.get().stream(), Stream.of(XMaterial.END_PORTAL.get())).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> BLOCK_DISPENSE_BUCKETS = Lazy.of(() -> Stream.of(XMaterial.WATER_BUCKET, XMaterial.LAVA_BUCKET, XMaterial.COD_BUCKET, XMaterial.SALMON_BUCKET, XMaterial.PUFFERFISH_BUCKET, XMaterial.TROPICAL_FISH_BUCKET, XMaterial.AXOLOTL_BUCKET, XMaterial.TADPOLE_BUCKET, XMaterial.POWDER_SNOW_BUCKET).filter(XBase::isSupported).map(XMaterial::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));
    public static final Lazy<Set<Material>> AIR = Lazy.of(() -> XTag.AIR.getValues().stream().filter(XBase::isSupported).map(XMaterial::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class))));

    public static boolean isElytra(@Nullable ItemStack itemStack) {
        return itemStack != null && itemStack.getType() == XMaterial.ELYTRA.get();
    }

    public static boolean isPlayerHead(BlockState blockState) {
        if (!PLAYER_HEADS.get().contains(blockState.getType())) {
            return false;
        }
        if (Platform.getServerVersion().isNewerThan(ServerVersion.V_1_12_2)) {
            return true;
        }
        return blockState.getData().getData() == XMaterial.PLAYER_HEAD.getData();
    }

    public static boolean isPlayerHead(ItemStack itemStack) {
        if (!PLAYER_HEADS.get().contains(itemStack.getType())) {
            return false;
        }
        if (Platform.getServerVersion().isNewerThan(ServerVersion.V_1_12_2)) {
            return true;
        }
        if (itemStack.getData() == null) {
            return false;
        }
        return itemStack.getData().getData() == XMaterial.PLAYER_HEAD.getData();
    }
}

