/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import java.lang.invoke.MethodHandle;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.utils.enums.Platform;
import me.xginko.aef.utils.reflection.ReflectionUtil;
import org.bukkit.World;

public final class WorldUtil {
    private static final MethodHandle GET_MIN_WORLD_HEIGHT;
    private static final MethodHandle RESPAWNANCHOR_WORKS;
    private static final MethodHandle BED_WORKS;
    public static final boolean GET_MIN_WORLD_HEIGHT_AVAILABLE;
    public static final boolean RESPAWN_ANCHOR_WORKS_AVAILABLE;
    public static final boolean BED_WORKS_AVAILABLE;

    public static boolean isRespawnAnchorWorks(World world) {
        if (RESPAWN_ANCHOR_WORKS_AVAILABLE) {
            try {
                return RESPAWNANCHOR_WORKS.invoke(world);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return world.getEnvironment() != World.Environment.NORMAL;
    }

    public static boolean isBedWorks(World world) {
        if (BED_WORKS_AVAILABLE) {
            try {
                return BED_WORKS.invoke(world);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return world.getEnvironment() == World.Environment.NORMAL;
    }

    public static int getMinWorldHeight(World world) {
        if (GET_MIN_WORLD_HEIGHT_AVAILABLE) {
            try {
                return GET_MIN_WORLD_HEIGHT.invoke(world);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return AnarchyExploitFixes.config().worldMinHeights.getOrDefault(world.getName(), WorldUtil.getDefaultMinHeight(world));
    }

    private static int getDefaultMinHeight(World world) {
        return world.getEnvironment() == World.Environment.NORMAL && Platform.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_17) ? -64 : 0;
    }

    static {
        GET_MIN_WORLD_HEIGHT_AVAILABLE = ReflectionUtil.hasMethod(World.class, "getMinHeight", new Class[0]);
        GET_MIN_WORLD_HEIGHT = ReflectionUtil.findMethod(World.class, "getMinHeight", Integer.TYPE, new Class[0]);
        RESPAWN_ANCHOR_WORKS_AVAILABLE = ReflectionUtil.hasMethod(World.class, "isRespawnAnchorWorks", new Class[0]);
        RESPAWNANCHOR_WORKS = ReflectionUtil.findMethod(World.class, "isRespawnAnchorWorks", Boolean.TYPE, new Class[0]);
        BED_WORKS_AVAILABLE = ReflectionUtil.hasMethod(World.class, "isBedWorks", new Class[0]);
        BED_WORKS = ReflectionUtil.findMethod(World.class, "isBedWorks", Boolean.TYPE, new Class[0]);
    }
}

