/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils.enums;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import me.xginko.aef.utils.reflection.ReflectionUtil;

public enum Platform {
    BUKKIT("Bukkit", true, ReflectionUtil.hasClass("org.bukkit.Bukkit")),
    SPIGOT("Spigot", true, ReflectionUtil.hasClass("org.spigotmc.SpigotConfig")),
    PAPER("Paper", true, ReflectionUtil.hasClass("com.destroystokyo.paper.PaperConfig") || ReflectionUtil.hasClass("io.papermc.paper.configuration.Configuration")),
    PURPUR("Purpur", false, ReflectionUtil.hasClass("org.purpurmc.purpur.PurpurConfig") || ReflectionUtil.hasClass("net.pl3x.purpur.PurpurConfig")),
    FOLIA("Folia", false, ReflectionUtil.hasClass("io.papermc.paper.threadedregions.RegionizedServer"));

    private final String niceName;
    private final boolean present;
    private final boolean required;

    private Platform(String niceName, boolean isRequired, boolean isPresent) {
        this.niceName = niceName;
        this.required = isRequired;
        this.present = isPresent;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isPresent() {
        return this.present;
    }

    public String toString() {
        return this.niceName;
    }

    public static Platform getMajorType() {
        if (FOLIA.isPresent()) {
            return FOLIA;
        }
        if (PURPUR.isPresent()) {
            return PURPUR;
        }
        if (PAPER.isPresent()) {
            return PAPER;
        }
        if (SPIGOT.isPresent()) {
            return SPIGOT;
        }
        if (BUKKIT.isPresent()) {
            return BUKKIT;
        }
        throw new IllegalStateException("Couldn't detect any Platform!");
    }

    public static ServerVersion getServerVersion() {
        return PacketEvents.getAPI().getServerManager().getVersion();
    }
}

