/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils.models;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.jetbrains.annotations.Nullable;

public final class ChunkUID {
    private final UUID worldUID;
    private final int x;
    private final int z;

    public static ChunkUID of(Chunk chunk) {
        return new ChunkUID(chunk.getWorld().getUID(), chunk.getX(), chunk.getZ());
    }

    private ChunkUID(UUID worldUID, int x, int z) {
        this.worldUID = worldUID;
        this.x = x;
        this.z = z;
    }

    public UUID getWorldUID() {
        return this.worldUID;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public CompletableFuture<@Nullable Chunk> getChunkAsync(boolean gen) {
        World world = Bukkit.getWorld((UUID)this.worldUID);
        return world == null ? CompletableFuture.completedFuture(null) : world.getChunkAtAsync(this.x, this.z, gen);
    }

    public String toString() {
        return ChunkUID.jvmdowngrader$concat$toString$1(this.x, this.z, String.valueOf(this.worldUID));
    }

    public int hashCode() {
        return Objects.hash(this.worldUID, this.x, this.z);
    }

    public boolean equals(Object obj) {
        if (null == obj || obj.getClass() != ChunkUID.class) {
            return false;
        }
        ChunkUID id = (ChunkUID)obj;
        return id.x == this.x && id.z == this.z && id.worldUID.equals(this.worldUID);
    }

    private static /* synthetic */ String jvmdowngrader$concat$toString$1(int n, int n2, String string) {
        return "ChunkUID{x=" + n + ", z=" + n2 + ", worldUID=" + string + "}";
    }
}

