/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils.models;

import java.time.Duration;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import org.jetbrains.annotations.NotNull;

public final class ExpiringSet<E>
extends AbstractSet<E>
implements Set<E> {
    private final Cache<E, Object> cache;
    private static final Object PRESENT = new Object();

    public ExpiringSet(long duration, TimeUnit unit) {
        this.cache = Caffeine.newBuilder().expireAfterWrite(duration, unit).build();
    }

    public ExpiringSet(Duration duration) {
        this.cache = Caffeine.newBuilder().expireAfterWrite(duration).build();
    }

    @Override
    public int size() {
        return this.cache.asMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.asMap().isEmpty();
    }

    @Override
    public boolean contains(Object item) {
        return this.cache.getIfPresent(item) != null;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.cache.asMap().keySet().iterator();
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return this.cache.asMap().keySet().toArray();
    }

    @Override
    @NotNull
    public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
        return this.cache.asMap().keySet().toArray(a);
    }

    @Override
    public boolean add(E item) {
        boolean containedBefore = this.contains(item);
        this.cache.put(item, PRESENT);
        return !containedBefore;
    }

    @Override
    public boolean remove(Object o) {
        boolean containedBefore = this.contains(o);
        this.cache.invalidate(o);
        return containedBefore;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        for (Object o : collection) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> collection) {
        boolean changed = false;
        for (E o : collection) {
            if (!this.add(o)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        boolean changed = false;
        for (Object e : this.cache.asMap().keySet()) {
            if (collection.contains(e) || !this.remove(e)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        boolean changed = false;
        for (Object e : this.cache.asMap().keySet()) {
            if (!this.remove(e)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    public void cleanUp() {
        this.cache.cleanUp();
    }
}

