/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils.permissions;

import org.bukkit.Bukkit;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public enum AEFPermission {
    BYPASS_ELYTRA("bypass.elytra", "Bypass elytra restrictions", PermissionDefault.FALSE),
    BYPASS_HEIGHT_LIMITS("bypass.heightlimits", "Bypass height restrictions if enabled", PermissionDefault.FALSE),
    BYPASS_CMD_WHITELIST("bypass.commandwhitelist", "Bypass command whitelist if enabled", PermissionDefault.OP),
    BYPASS_CHAT("bypass.chat", "Bypass for any kind of other chat restrictions", PermissionDefault.OP),
    BYPASS_PREVENTION_COMMANDSIGN("bypass.prevention.commandsign", "Bypass commandsign prevention", PermissionDefault.FALSE),
    BYPASS_ILLEGAL_FIREWORKS("bypass.illegal.firework", "Bypass illegal firework checks", PermissionDefault.FALSE),
    BYPASS_ILLEGAL_POTIONS("bypass.illegal.potions", "Bypass illegal potion checks", PermissionDefault.FALSE),
    BYPASS_ILLEGAL_ATTRIBUTES("bypass.illegal.attributes", "Bypass attribute and itemflag checks", PermissionDefault.FALSE),
    BYPASS_ILLEGAL_COMPONENT_TYPES("bypass.illegal.component.types", "Bypass component checks", PermissionDefault.FALSE),
    BYPASS_ILLEGAL_OVERSTACKED("bypass.illegal.overstacked", "Bypass overstacked item checks", PermissionDefault.FALSE),
    BYPASS_ILLEGAL_BANNEDMATERIAL("bypass.illegal.bannedmaterial", "Bypass banned material checks", PermissionDefault.FALSE),
    BYPASS_ILLEGAL_BANNEDNAME("bypass.illegal.bannedname", "Bypass banned item name checks", PermissionDefault.FALSE),
    BYPASS_ILLEGAL_UNBREAKABLE("bypass.illegal.unbreakable", "Bypass unbreakable item checks", PermissionDefault.FALSE),
    BYPASS_ILLEGAL_SPAWNEGG("bypass.illegal.spawnegg", "Bypass spawnegg item checks", PermissionDefault.FALSE),
    BYPASS_ILLEGAL_PLAYERHEAD("bypass.illegal.playerhead", "Bypass playerhead item checks", PermissionDefault.FALSE),
    BYPASS_ILLEGAL_NBT_COMMAND_ITEM("bypass.illegal.nbt.commanditem", "Bypass nbt command item checks", PermissionDefault.FALSE),
    BYPASS_ILLEGAL_NBT_STOREDITEMS("bypass.illegal.nbt.storeditems", "Bypass checks for illegally stored items using nbt", PermissionDefault.FALSE),
    BYPASS_ILLEGAL_NBT_CUSTOM("bypass.illegal.nbt.custom", "Bypass custom nbt item checks", PermissionDefault.FALSE),
    BYPASS_ILLEGAL_ENCHANT_HIGHER("bypass.illegal.enchants.higher", "Bypass higher enchanted item checks", PermissionDefault.FALSE),
    BYPASS_ILLEGAL_ENCHANT_INAPPLICABLE("bypass.illegal.enchants.inapplicable", "Bypass inapplicable enchanted item checks", PermissionDefault.FALSE),
    BYPASS_ILLEGAL_ENCHANT_INCOMPATIBLE("bypass.illegal.enchants.incompatible", "Bypass incompatible enchanted item checks", PermissionDefault.FALSE),
    BYPASS_ILLEGAL_DATA_APPLE("bypass.illegal.data.apple", "Bypass illegal apple item checks", PermissionDefault.FALSE),
    BYPASS_ILLEGAL_DATA_CUSTOM("bypass.illegal.data.custom", "Bypass illegal material data item checks", PermissionDefault.FALSE),
    BYPASS_MAP_SPAM("bypass.mapspam", "Bypass map antispam", PermissionDefault.FALSE),
    BYPASS_CMD_SPAM("bypass.commandspam", "Bypass command antispam", PermissionDefault.FALSE),
    SILENT_JOIN("silentJoin", "Disable messages when joining the server", PermissionDefault.FALSE),
    SILENT_LEAVE("silentLeave", "Disable messages when leaving the server", PermissionDefault.FALSE),
    CMD_AEF_RELOAD("cmd.reload", "Reload the plugin", PermissionDefault.OP),
    CMD_AEF_DISABLE("cmd.disable", "Disable the plugin", PermissionDefault.OP),
    CMD_AEF_VERSION("cmd.version", "Show the plugin version", PermissionDefault.OP),
    CMD_AEF_LAG("cmd.lag", "Artificially lag the server", PermissionDefault.OP),
    CMD_AEF_DATAVALUE("cmd.datavalue", "Show the MaterialData value of a held item", PermissionDefault.OP),
    CMD_AEF_SIZE_HAND("cmd.size.hand", "Show the item size of a player's main hand", PermissionDefault.OP),
    CMD_AEF_SIZE_INV("cmd.size.inventory", "Show the inventory size of a player", PermissionDefault.OP),
    CMD_AEF_ELYTRA("cmd.elytra", "Show how many players are currently flying using an elytra", PermissionDefault.OP),
    CMD_AEF_GEARED("cmd.geared", "Show how many players are geared", PermissionDefault.OP),
    CMD_TOGGLE_CONNECT_MSGS("cmd.toggleconnectionmsgs", "Toggle join/leave messages", PermissionDefault.TRUE),
    CMD_TOGGLE_FIRST_JOIN_MSGS("cmd.togglefirstjoinmsgs", "Toggle first join messages", PermissionDefault.TRUE),
    CMD_SAY("cmd.say", "Broadcast a message using your own prefix and format", PermissionDefault.OP),
    CMD_HELP("cmd.help", "Show a command overview for players", PermissionDefault.TRUE);

    private final Permission permission;

    private AEFPermission(String perm, String description, PermissionDefault def) {
        this.permission = new Permission(AEFPermission.jvmdowngrader$concat$$init$$1(perm), description, def);
    }

    public String node() {
        return this.permission.getName();
    }

    public Permission bukkit() {
        return this.permission;
    }

    public static void registerAll() {
        for (AEFPermission aefPermission : AEFPermission.values()) {
            try {
                Bukkit.getPluginManager().addPermission(aefPermission.bukkit());
            }
            catch (IllegalArgumentException e) {
                Bukkit.getPluginManager().addPermission(new Permission(AEFPermission.jvmdowngrader$concat$registerAll$1(System.currentTimeMillis(), aefPermission.node()), aefPermission.bukkit().getDescription(), aefPermission.bukkit().getDefault()));
            }
        }
    }

    public static void unregisterAll() {
        for (AEFPermission aefPermission : AEFPermission.values()) {
            Bukkit.getPluginManager().removePermission(aefPermission.bukkit());
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$1(String string) {
        return "aef." + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$registerAll$1(long l, String string) {
        return l + "_broken." + string;
    }
}

