/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils.permissions;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.utils.enums.TriState;
import me.xginko.aef.utils.permissions.PermissionHandler;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class BukkitPermissionHandler
implements PermissionHandler,
Listener {
    private final Map<Permissible, Cache<String, TriState>> permissibleStateCacheMap = new ConcurrentHashMap<Permissible, Cache<String, TriState>>();
    private final Duration permissionStateCacheDuration;

    BukkitPermissionHandler(JavaPlugin plugin, Duration cacheDuration) {
        this.permissionStateCacheDuration = cacheDuration;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        this.permissibleStateCacheMap.keySet().forEach(this::cleanUpCache);
    }

    @Override
    public TriState permissionValue(Permissible permissible, String permission) {
        return this.getPermissionStateCache(permissible).get(permission, p -> permissible.isPermissionSet(p) ? TriState.of(permissible.hasPermission(p)) : TriState.UNDEFINED);
    }

    @Override
    public void setPermission(Permissible permissible, String permission, TriState state) {
        for (PermissionAttachmentInfo attachmentInfo : permissible.getEffectivePermissions()) {
            if (attachmentInfo.getAttachment() == null || !attachmentInfo.getPermission().equals(permission)) continue;
            if (state == TriState.UNDEFINED) {
                permissible.removeAttachment(attachmentInfo.getAttachment());
            } else {
                permissible.addAttachment(attachmentInfo.getAttachment().getPlugin(), permission, state.toBoolean());
            }
            this.getPermissionStateCache(permissible).put(permission, state);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPlayerQuit(PlayerQuitEvent event) {
        this.cleanUpCache((Permissible)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPlayerKick(PlayerKickEvent event) {
        this.cleanUpCache((Permissible)event.getPlayer());
    }

    private Cache<String, TriState> getPermissionStateCache(Permissible permissible) {
        return this.permissibleStateCacheMap.computeIfAbsent(permissible, p -> Caffeine.newBuilder().expireAfterWrite(this.permissionStateCacheDuration).build());
    }

    private void cleanUpCache(Permissible permissible) {
        if (this.permissibleStateCacheMap.containsKey(permissible)) {
            this.permissibleStateCacheMap.get(permissible).invalidateAll();
            this.permissibleStateCacheMap.get(permissible).cleanUp();
            this.permissibleStateCacheMap.remove(permissible);
        }
    }
}

