/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils.reflection;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import me.xginko.aef.utils.reflection.ReflectionUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public final class CommandReflection {
    private static CommandReflection instance;
    private Method syncCommandsMethod;
    private Method removeCommandMethod;
    private Field bField;
    private Field vanillaCommandDispatcherField;
    private Field commandMapField;
    private Field knownCommandsField;

    public static CommandReflection get() {
        if (instance == null) {
            instance = new CommandReflection();
        }
        return instance;
    }

    public void removeCommand(String command) {
        if (!this.resolveVanillaCommandDispatcherField()) {
            return;
        }
        CommandDispatcher<?> commandDispatcher = this.getDispatcher();
        if (commandDispatcher == null) {
            return;
        }
        if (!this.resolveRemoveCommandMethod()) {
            return;
        }
        try {
            this.removeCommandMethod.invoke((Object)commandDispatcher.getRoot(), command);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    public void setKnownCommands(Map<String, Command> knownCommands) {
        SimpleCommandMap commandMap;
        if (!this.fetchCommandMapField()) {
            return;
        }
        try {
            commandMap = (SimpleCommandMap)this.commandMapField.get(Bukkit.getServer());
        }
        catch (Exception e) {
            return;
        }
        if (!this.fetchKnownCommandsField()) {
            return;
        }
        try {
            this.knownCommandsField.set(commandMap, knownCommands);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public void syncCommands() {
        if (!this.resolveSyncCommandsMethod()) {
            return;
        }
        try {
            this.syncCommandsMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.updateCommands();
        }
    }

    private boolean resolveSyncCommandsMethod() {
        if (this.syncCommandsMethod != null) {
            return true;
        }
        try {
            this.syncCommandsMethod = ReflectionUtil.CRAFT_SERVER_CLASS.get().getDeclaredMethod("syncCommands", new Class[0]);
            this.syncCommandsMethod.setAccessible(true);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private boolean fetchCommandMapField() {
        if (this.commandMapField != null) {
            return true;
        }
        try {
            this.commandMapField = ReflectionUtil.CRAFT_SERVER_CLASS.get().getDeclaredField("commandMap");
            this.commandMapField.setAccessible(true);
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    private boolean fetchKnownCommandsField() {
        if (this.knownCommandsField != null) {
            return true;
        }
        try {
            this.knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
            this.knownCommandsField.setAccessible(true);
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    private boolean resolveRemoveCommandMethod() {
        if (this.removeCommandMethod == null) {
            try {
                try {
                    this.removeCommandMethod = RootCommandNode.class.getDeclaredMethod("removeCommand", String.class);
                }
                catch (NoSuchMethodError | NoSuchMethodException ex) {
                    this.removeCommandMethod = CommandNode.class.getDeclaredMethod("removeCommand", String.class);
                }
                return true;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private CommandDispatcher<?> getDispatcher() {
        Object vanillaCommandDispatcher = this.getVanillaCommandDispatcher();
        if (vanillaCommandDispatcher == null || !this.resolveBField()) {
            return null;
        }
        try {
            return (CommandDispatcher)this.bField.get(vanillaCommandDispatcher);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Nullable
    private Object getVanillaCommandDispatcher() {
        try {
            return this.vanillaCommandDispatcherField.get(ReflectionUtil.MC_SERVER_INSTANCE.get());
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private boolean resolveVanillaCommandDispatcherField() {
        if (this.vanillaCommandDispatcherField != null) {
            return true;
        }
        try {
            this.vanillaCommandDispatcherField = ReflectionUtil.MC_SERVER_CLASS.get().getDeclaredField("vanillaCommandDispatcher");
            this.vanillaCommandDispatcherField.setAccessible(true);
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    private boolean resolveBField() {
        if (this.bField != null) {
            return true;
        }
        Class<?> commandDispatcher = ReflectionUtil.findNmsClass("CommandDispatcher");
        if (commandDispatcher == null) {
            return false;
        }
        try {
            this.bField = commandDispatcher.getDeclaredField("b");
        }
        catch (NoSuchFieldException e) {
            try {
                Field gField = commandDispatcher.getDeclaredField("g");
                this.bField = gField.getType() == CommandDispatcher.class ? gField : commandDispatcher.getDeclaredField("h");
            }
            catch (NoSuchFieldException ex) {
                return false;
            }
        }
        try {
            this.bField.setAccessible(true);
            return true;
        }
        catch (Throwable t2) {
            return false;
        }
    }
}

