/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils.reflection;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import java.lang.reflect.Field;
import me.xginko.aef.utils.enums.Platform;
import me.xginko.aef.utils.reflection.ReflectionUtil;

public final class TickTimesReflection {
    private static TickTimesReflection instance;
    private final Field MinecraftServer_recentTps_field = ReflectionUtil.needField(ReflectionUtil.MC_SERVER_CLASS.get(), "recentTps");
    private final Field MinecraftServer_recentTickTimes_field = TickTimesReflection.needTickTimesField(ReflectionUtil.MC_SERVER_CLASS.get());

    private TickTimesReflection() {
    }

    public static TickTimesReflection get() {
        if (instance == null) {
            instance = new TickTimesReflection();
        }
        return instance;
    }

    private static Field needTickTimesField(Class<?> MinecraftServer_class) {
        String tickTimes;
        if (Platform.getServerVersion().isOlderThanOrEquals(ServerVersion.V_1_12_2)) {
            tickTimes = "h";
        } else if (Platform.getServerVersion().isOlderThanOrEquals(ServerVersion.V_1_13) && !Platform.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_14)) {
            tickTimes = "d";
        } else if (Platform.getServerVersion().isOlderThanOrEquals(ServerVersion.V_1_14) && !Platform.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_16)) {
            tickTimes = "f";
        } else if (Platform.getServerVersion().isOlderThanOrEquals(ServerVersion.V_1_16) && !Platform.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_17)) {
            tickTimes = "h";
        } else if (Platform.getServerVersion().isOlderThanOrEquals(ServerVersion.V_1_17) && !Platform.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_18)) {
            tickTimes = "n";
        } else if (Platform.getServerVersion().isOlderThanOrEquals(ServerVersion.V_1_18) && !Platform.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19)) {
            tickTimes = "o";
        } else if (Platform.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19) && !Platform.getServerVersion().isOlderThan(ServerVersion.V_1_19_2)) {
            tickTimes = "k";
        } else if (Platform.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20) && !Platform.getServerVersion().isOlderThan(ServerVersion.V_1_20_5)) {
            tickTimes = "ac";
        } else if (Platform.getServerVersion().isOlderThanOrEquals(ServerVersion.V_1_20)) {
            tickTimes = "ab";
        } else {
            throw new IllegalStateException("Don't know tickTimes field name!");
        }
        return ReflectionUtil.needField(MinecraftServer_class, tickTimes);
    }

    public double[] getTPS() {
        try {
            return (double[])this.MinecraftServer_recentTps_field.get(ReflectionUtil.MC_SERVER_INSTANCE.get());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to get recent TPS!", e);
        }
    }

    public double getAverageTickTime() {
        try {
            return this.toMillis(this.getAverage((long[])this.MinecraftServer_recentTickTimes_field.get(ReflectionUtil.MC_SERVER_INSTANCE.get())));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to get average tick time!", e);
        }
    }

    private double getAverage(long[] recentTickTimes) {
        long i = 0L;
        for (long l : recentTickTimes) {
            i += l;
        }
        return (double)i / (double)recentTickTimes.length;
    }

    private double toMillis(double averageTickTime) {
        return averageTickTime * 1.0E-6;
    }
}

