/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import de.tr7zw.nbtapi.NBT;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import me.xginko.aef.commands.AEFCommand;
import me.xginko.aef.config.Config;
import me.xginko.aef.config.Translation;
import me.xginko.aef.libs.bstats.bukkit.Metrics;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.KyoriUtil;
import me.xginko.aef.utils.LocaleUtil;
import me.xginko.aef.utils.enums.Platform;
import me.xginko.aef.utils.models.VersionChecker;
import me.xginko.aef.utils.permissions.AEFPermission;
import me.xginko.aef.utils.permissions.PermissionHandler;
import me.xginko.aef.utils.tickdata.TickReporter;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class AnarchyExploitFixes
extends JavaPlugin {
    private static AnarchyExploitFixes instance;
    private static Map<Locale, Translation> translations;
    private static Config config;
    private static TickReporter tickReporter;
    private static PermissionHandler permissionHandler;
    private static ComponentLogger componentLogger;
    private Metrics metrics;
    private VersionChecker versionChecker;

    public void onLoad() {
        Configurator.setLevel((String)(AnarchyExploitFixes.class.getPackage().getName() + ".libs.reflections.Reflections"), (Level)Level.WARN);
    }

    public void onEnable() {
        instance = this;
        List<Platform> required = Arrays.stream(Platform.values()).filter(Platform::isRequired).toList();
        if (required.stream().anyMatch(platform -> !platform.isPresent())) {
            List<String> missing = required.stream().filter(platform -> !platform.isPresent()).map(Platform::toString).toList();
            this.getLogger().severe("AEF requires the following " + (missing.size() > 1 ? "platforms" : "platform") + " to enable: " + String.join((CharSequence)", ", missing) + ".");
            this.getServer().getPluginManager().disablePlugin((Plugin)instance);
            return;
        }
        componentLogger = this.getComponentLogger();
        if (this.getServer().getPluginManager().getPlugin("packetevents") == null) {
            Stream.of("                                                               ", "       _   _   _             _   _                             ", "      / \\ | |_| |_ ___ _ __ | |_(_) ___  _ __                 ", "     / _ \\| __| __/ _ \\ '_ \\| __| |/ _ \\| '_ \\            ", "    / ___ \\ |_| ||  __/ | | | |_| | (_) | | | |               ", "   /_/   \\_\\__|\\__\\___|_| |_|\\__|_|\\___/|_| |_|          ", "                                                               ", "   AEF depends on PacketEvents to function!                    ", "   You can either download the latest release on modrinth:     ", "   https://modrinth.com/plugin/packetevents/                   ", "   or choose a dev build on their jenkins:                     ", "   https://ci.codemc.io/job/retrooper/job/packetevents/        ", "                                                               ").forEach(arg_0 -> AnarchyExploitFixes.logger().error(arg_0));
            this.getServer().shutdown();
            return;
        }
        if (this.getServer().getPluginManager().getPlugin("NBTAPI") == null) {
            Stream.of("                                                               ", "       _   _   _             _   _                             ", "      / \\ | |_| |_ ___ _ __ | |_(_) ___  _ __                 ", "     / _ \\| __| __/ _ \\ '_ \\| __| |/ _ \\| '_ \\            ", "    / ___ \\ |_| ||  __/ | | | |_| | (_) | | | |               ", "   /_/   \\_\\__|\\__\\___|_| |_|\\__|_|\\___/|_| |_|          ", "                                                               ", "   AEF depends on NBT-API to function!                         ", "   You can either download the latest release on modrinth:     ", "   https://modrinth.com/plugin/nbtapi/                         ", "   or choose a dev build on github actions:                    ", "   https://github.com/tr7zw/Item-NBT-API/actions               ", "                                                               ").forEach(arg_0 -> AnarchyExploitFixes.logger().error(arg_0));
            this.getServer().shutdown();
            return;
        }
        Stream.of("                                                          ", "                                                          ", "     \u2588\u2588\u2588\u2588\u2588  \u2588\u2588\u2588\u2588\u2588\u2588\u2588 \u2588\u2588\u2588\u2588\u2588\u2588\u2588                               ", "    \u2588\u2588   \u2588\u2588 \u2588\u2588      \u2588\u2588             AnarchyExploitFixes    ", "    \u2588\u2588\u2588\u2588\u2588\u2588\u2588 \u2588\u2588\u2588\u2588\u2588   \u2588\u2588\u2588\u2588\u2588            Made by moom0o       ", "    \u2588\u2588   \u2588\u2588 \u2588\u2588      \u2588\u2588             Rewritten by xGinko    ", "    \u2588\u2588   \u2588\u2588 \u2588\u2588\u2588\u2588\u2588\u2588\u2588 \u2588\u2588                                    ", "                                                          ", "                                                          ").map(str -> (TextComponent)Component.text((String)str).color(KyoriUtil.AEF_WHITE)).forEach(arg_0 -> ((ComponentLogger)AnarchyExploitFixes.logger()).info(arg_0));
        AnarchyExploitFixes.logger().info("Detected {} {}", (Object)Platform.getMajorType().toString(), (Object)Platform.getServerVersion().getReleaseName());
        if (Platform.getServerVersion().isOlderThan(ServerVersion.V_1_19_4) || Platform.getServerVersion().equals((Object)ServerVersion.V_1_19_4) && !Platform.FOLIA.isPresent()) {
            AnarchyExploitFixes.logger().error("This plugin jar is incompatible with your Server. Please use the Legacy jar.");
            this.getServer().getPluginManager().disablePlugin((Plugin)instance);
            return;
        }
        try {
            Files.createDirectories(this.getDataFolder().toPath(), new FileAttribute[0]);
        }
        catch (Exception e) {
            AnarchyExploitFixes.logger().error("Unable to create plugin directory.", (Throwable)e);
            this.getServer().getPluginManager().disablePlugin((Plugin)instance);
            return;
        }
        Logger.getLogger("NBTAPI").setLevel(java.util.logging.Level.WARNING);
        if (!NBT.preloadApi()) {
            AnarchyExploitFixes.logger().error(" ");
            AnarchyExploitFixes.logger().error("           Error preloading NBT-API!           ");
            AnarchyExploitFixes.logger().error(" !! This will break all NBT related modules !! ");
            AnarchyExploitFixes.logger().error(" ");
            AnarchyExploitFixes.logger().error("         The reason for this could be:         ");
            AnarchyExploitFixes.logger().error(" - your server version is too new for the      ");
            AnarchyExploitFixes.logger().error("   item-nbt-api-plugin.jar in your plugins     ");
            AnarchyExploitFixes.logger().error("   folder.                                     ");
            AnarchyExploitFixes.logger().error(" - the item-nbt-api-plugin.jar in your         ");
            AnarchyExploitFixes.logger().error("   plugins folder is bad.                      ");
            AnarchyExploitFixes.logger().error(" ");
        }
        AnarchyExploitFixes.logger().info("Registering Permissions");
        AEFPermission.registerAll();
        AnarchyExploitFixes.logger().info("Loading Config");
        this.reloadConfiguration();
        AnarchyExploitFixes.logger().info("Loading Translations");
        this.reloadTranslations();
        AnarchyExploitFixes.logger().info("Loading Metrics");
        this.metrics = new Metrics(instance, 8700);
        AnarchyExploitFixes.logger().info("Done.");
    }

    public void onDisable() {
        AEFModule.disableAll();
        AEFCommand.disableAll();
        AEFPermission.unregisterAll();
        if (permissionHandler != null) {
            permissionHandler.disable();
            permissionHandler = null;
        }
        if (this.versionChecker != null) {
            this.versionChecker.disable();
            this.versionChecker = null;
        }
        if (tickReporter != null) {
            tickReporter.disable();
            tickReporter = null;
        }
        if (translations != null) {
            translations.clear();
            translations = null;
        }
        if (this.metrics != null) {
            this.metrics.shutdown();
            this.metrics = null;
        }
        componentLogger = null;
        instance = null;
        config = null;
    }

    public static AnarchyExploitFixes getInstance() {
        return instance;
    }

    public static PermissionHandler permissions() {
        return permissionHandler;
    }

    public static TickReporter tickReporter() {
        return tickReporter;
    }

    public static Config config() {
        return config;
    }

    public static ComponentLogger logger() {
        return componentLogger;
    }

    public static Translation translation(Pointered pointered) {
        return AnarchyExploitFixes.translation((Locale)pointered.pointers().getOrDefault(Identity.LOCALE, (Object)AnarchyExploitFixes.config.default_lang));
    }

    public static Translation translation(Locale locale) {
        if (AnarchyExploitFixes.config.auto_lang) {
            return translations.getOrDefault(locale, translations.get(AnarchyExploitFixes.config.default_lang));
        }
        return translations.get(AnarchyExploitFixes.config.default_lang);
    }

    public void reloadPlugin() {
        this.reloadConfiguration();
        this.reloadTranslations();
    }

    private void reloadConfiguration() {
        try {
            config = new Config();
            if (tickReporter != null) {
                tickReporter.disable();
            }
            tickReporter = TickReporter.create(this, AnarchyExploitFixes.config.tickData_cache_duration);
            if (permissionHandler != null) {
                permissionHandler.disable();
            }
            permissionHandler = PermissionHandler.create(this, AnarchyExploitFixes.config.permissions_cache_time, AnarchyExploitFixes.config.permissions_hook);
            if (this.versionChecker != null) {
                this.versionChecker.disable();
            }
            if (AnarchyExploitFixes.config.update_checker_enabled) {
                this.versionChecker = new VersionChecker(instance);
            }
            AEFModule.reloadModules();
            AEFCommand.reloadCommands();
            config.saveConfig();
        }
        catch (Throwable t) {
            AnarchyExploitFixes.logger().error("Failed while loading config!", t);
        }
    }

    public void reloadTranslations() {
        List<Locale> available = this.getAvailableTranslations();
        if (available.isEmpty()) {
            AnarchyExploitFixes.logger().error("No translations available for loading. Keeping previous translation if there are any.");
        } else {
            HashMap<Locale, Translation> newTranslations = new HashMap<Locale, Translation>(available.size());
            StringBuilder neatlyListedTranslations = new StringBuilder();
            for (int i = 0; i < available.size(); ++i) {
                neatlyListedTranslations.append(LocaleUtil.languageTagForLocale(available.get(i)));
                try {
                    newTranslations.put(available.get(i), new Translation(available.get(i)));
                }
                catch (Exception e) {
                    neatlyListedTranslations.append("(error)");
                }
                if (i < available.size() - 1) {
                    neatlyListedTranslations.append(", ");
                }
                if ((i + 1) % 4 != 0 && i != available.size() - 1) continue;
                AnarchyExploitFixes.logger().info(neatlyListedTranslations.toString());
                neatlyListedTranslations.setLength(0);
            }
            if (!newTranslations.isEmpty()) {
                if (newTranslations.containsKey(AnarchyExploitFixes.config.default_lang)) {
                    translations = newTranslations;
                    AnarchyExploitFixes.logger().info("Loaded {} translations.", (Object)translations.size());
                } else {
                    AnarchyExploitFixes.logger().error("Can't find translation for default language '{}'!", (Object)AnarchyExploitFixes.config.default_lang);
                }
            }
        }
        if (translations == null || translations.isEmpty()) {
            AnarchyExploitFixes.logger().error("Unable to load translations. Disabling.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    @NotNull
    private List<Locale> getAvailableTranslations() {
        List<Locale> list;
        JarFile pluginJar = new JarFile(this.getFile());
        try {
            Stream<String> fileNames = null;
            File langFolder = new File(this.getDataFolder(), "/lang");
            if (langFolder.exists()) {
                if (langFolder.isDirectory()) {
                    File[] files = langFolder.listFiles();
                    if (files != null && files.length > 0) {
                        fileNames = Arrays.stream(files).map(File::getName);
                    }
                } else {
                    String newName = langFolder.getPath() + ".non-directory";
                    AnarchyExploitFixes.logger().warn("Found weird non-directory file at '{}'. Renaming to '{}'.", (Object)langFolder.getPath(), (Object)newName);
                    if (!langFolder.renameTo(new File(newName))) {
                        throw new FileAlreadyExistsException("Could not rename existing file at lang directory path.");
                    }
                    Files.createDirectories(langFolder.toPath(), new FileAttribute[0]);
                }
            } else {
                Files.createDirectories(langFolder.toPath(), new FileAttribute[0]);
            }
            if (fileNames == null) {
                fileNames = pluginJar.stream().map(ZipEntry::getName);
            }
            list = fileNames.map(LocaleUtil.LANGUAGE_TAG_PATTERN::matcher).filter(Matcher::find).map(matcher -> matcher.group(1)).distinct().sorted().map(LocaleUtil::localeForLanguageTag).filter(locale -> AnarchyExploitFixes.config.auto_lang || locale == AnarchyExploitFixes.config.default_lang).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    pluginJar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                AnarchyExploitFixes.logger().error("Failed while searching for available translations!", (Throwable)e);
                return Collections.emptyList();
            }
        }
        pluginJar.close();
        return list;
    }
}

