/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.commands;

import java.util.Collections;
import java.util.List;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.commands.AEFCommand;
import me.xginko.aef.utils.enums.AEFKey;
import me.xginko.aef.utils.permissions.AEFPermission;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class ToggleConnectionMsgsCmd
extends AEFCommand {
    public ToggleConnectionMsgsCmd() {
        super("toggleconnectionmsgs", "Toggle connection messages on/off", "/toggleconnectionmsgs | /togglejoins", Collections.singletonList("togglejoins"));
    }

    @Override
    public boolean shouldEnable() {
        return AnarchyExploitFixes.config().cmd_toggleConMsgs_enabled;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws CommandException, IllegalArgumentException {
        return Collections.emptyList();
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        if (!AnarchyExploitFixes.permissions().permissionValue((Permissible)sender, AEFPermission.CMD_TOGGLE_CONNECT_MSGS.node()).toBoolean()) {
            sender.sendMessage(AnarchyExploitFixes.translation((Pointered)sender).no_permission);
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage((Component)Component.text((String)"Only players can execute this command.", (TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)sender;
        player.getScheduler().run(this.getPlugin(), toggleJoinLeaveSettings -> {
            PersistentDataContainer dataContainer = player.getPersistentDataContainer();
            boolean msgsWereVisibleBeforeCmd = !dataContainer.has(AEFKey.CONNECT_MSG_TOGGLE.getKey(), PersistentDataType.BOOLEAN) ? AnarchyExploitFixes.config().connectionMsgsAreOnByDefault : (Boolean)dataContainer.get(AEFKey.CONNECT_MSG_TOGGLE.getKey(), PersistentDataType.BOOLEAN);
            dataContainer.set(AEFKey.CONNECT_MSG_TOGGLE.getKey(), PersistentDataType.BOOLEAN, (Object)(!msgsWereVisibleBeforeCmd ? 1 : 0));
            if (msgsWereVisibleBeforeCmd) {
                player.sendMessage(AnarchyExploitFixes.translation((Pointered)player).misc_disabledConnectionMsgs);
            } else {
                player.sendMessage(AnarchyExploitFixes.translation((Pointered)player).misc_enabledConnectionMsgs);
            }
        }, null);
        return true;
    }
}

