/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.commands.aef;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.xginko.aef.commands.AEFCommand;
import me.xginko.aef.commands.aef.subcommands.DisableSubCmd;
import me.xginko.aef.commands.aef.subcommands.ElytraSubCmd;
import me.xginko.aef.commands.aef.subcommands.GearedSubCmd;
import me.xginko.aef.commands.aef.subcommands.LagSubCmd;
import me.xginko.aef.commands.aef.subcommands.ReloadSubCmd;
import me.xginko.aef.commands.aef.subcommands.VersionSubCmd;
import me.xginko.aef.commands.aef.subcommands.bytesize.ByteSizeSubCmd;
import me.xginko.aef.utils.models.SubCommand;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class AEFCmd
extends AEFCommand {
    @NotNull
    private final Set<SubCommand> subCommands;
    @NotNull
    private final List<String> tabCompletes;
    @NotNull
    private final List<Component> overview = (List)Stream.of("", "                 <#00edff><bold>AnarchyExploitFixes Commands", "", "  <#00edff>/aef version <#869699>- <#e2fdff>Show the plugin version.", "  <#00edff>/aef reload <#869699>- <#e2fdff>Reload the plugin.", "  <#00edff>/aef disable <#869699>- <#e2fdff>Disable the plugin.", "  <#00edff>/aef lag <millis> <#869699>- <#e2fdff>Lag the server for testing.", "  <#00edff>/aef geared <#869699>- <#e2fdff>Count how many players are wearing gear.", "  <#00edff>/aef elytra <#869699>- <#e2fdff>Count how many players are flying elytra.", "  <#00edff>/aef bytesize <mainhand/inventory> (player) (utf8/utf16)", "                      <#869699>- <#e2fdff>Get the byte size of an item or inventory.", "").map(arg_0 -> ((MiniMessage)MiniMessage.miniMessage()).deserialize(arg_0)).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));

    public AEFCmd() {
        super("aef", "AnarchyExploitFixes admin commands", "/aef <reload, version, bytesize, disable, elytra, geared, lag>", Collections.emptyList());
        this.subCommands = ImmutableSet.of((Object)new ReloadSubCmd(), (Object)new VersionSubCmd(), (Object)new DisableSubCmd(), (Object)new ByteSizeSubCmd(), (Object)new LagSubCmd(), (Object)new ElytraSubCmd(), (Object[])new SubCommand[]{new GearedSubCmd()});
        this.tabCompletes = (List)this.subCommands.stream().map(SubCommand::label).sorted().collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws CommandException, IllegalArgumentException {
        if (args.length == 1) {
            return this.tabCompletes.stream().filter(cmd -> cmd.toLowerCase(Locale.ROOT).startsWith(args[0].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        if (args.length > 1) {
            for (SubCommand subCommand : this.subCommands) {
                if (!args[0].equalsIgnoreCase(subCommand.label())) continue;
                return subCommand.tabComplete(sender, alias, args);
            }
        }
        return Collections.emptyList();
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        if (args.length > 0) {
            for (SubCommand subCommand : this.subCommands) {
                if (!args[0].equalsIgnoreCase(subCommand.label())) continue;
                return subCommand.execute(sender, commandLabel, args);
            }
        }
        this.overview.forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
        return true;
    }
}

