/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.commands.aef.subcommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.utils.KyoriUtil;
import me.xginko.aef.utils.models.SubCommand;
import me.xginko.aef.utils.permissions.AEFPermission;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class GearedSubCmd
extends SubCommand {
    @Override
    @NotNull
    public String label() {
        return "geared";
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws CommandException, IllegalArgumentException {
        return Collections.emptyList();
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        if (!AnarchyExploitFixes.permissions().permissionValue((Permissible)sender, AEFPermission.CMD_AEF_GEARED.node()).toBoolean()) {
            sender.sendMessage(AnarchyExploitFixes.translation((Pointered)sender).no_permission);
            return true;
        }
        ArrayList<String> geared = new ArrayList<String>();
        ArrayList<String> ungeared = new ArrayList<String>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (Arrays.stream(player.getInventory().getArmorContents()).anyMatch(Objects::nonNull)) {
                geared.add(player.getName());
                continue;
            }
            ungeared.add(player.getName());
        }
        sender.sendMessage((Component)Component.empty());
        sender.sendMessage(((TextComponent)((TextComponent)Component.text((String)" Geared players: ").color(KyoriUtil.AEF_WHITE)).append(Component.text((String)String.join((CharSequence)", ", geared)).color(KyoriUtil.AEF_BLUE))).append(Component.text((String)(" (" + geared.size() + ")")).color(KyoriUtil.AEF_WHITE)));
        sender.sendMessage(((TextComponent)((TextComponent)Component.text((String)" Ungeared players: ").color(KyoriUtil.AEF_WHITE)).append(Component.text((String)String.join((CharSequence)", ", ungeared)).color(KyoriUtil.AEF_BLUE))).append(Component.text((String)(" (" + ungeared.size() + ")")).color(KyoriUtil.AEF_WHITE)));
        sender.sendMessage(((TextComponent)Component.text((String)" Total players: ").color(KyoriUtil.AEF_WHITE)).append(Component.text((String)Integer.toString(geared.size() + ungeared.size())).color(KyoriUtil.AEF_BLUE)));
        sender.sendMessage((Component)Component.empty());
        return true;
    }
}

