/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.commands.aef.subcommands;

import java.util.Collections;
import java.util.List;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.utils.KyoriUtil;
import me.xginko.aef.utils.models.SubCommand;
import me.xginko.aef.utils.permissions.AEFPermission;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class LagSubCmd
extends SubCommand {
    private final List<String> tabCompletes = List.of("1000", "2500", "5000");

    @Override
    @NotNull
    public String label() {
        return "lag";
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws CommandException, IllegalArgumentException {
        if (args.length == 2 && AnarchyExploitFixes.permissions().permissionValue((Permissible)sender, AEFPermission.CMD_AEF_LAG.node()).toBoolean()) {
            return this.tabCompletes;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        if (!AnarchyExploitFixes.permissions().permissionValue((Permissible)sender, AEFPermission.CMD_AEF_LAG.node()).toBoolean()) {
            sender.sendMessage(AnarchyExploitFixes.translation((Pointered)sender).no_permission);
            return true;
        }
        if (args.length != 2) {
            return true;
        }
        AnarchyExploitFixes plugin = AnarchyExploitFixes.getInstance();
        try {
            long millis = Long.parseLong(args[1]);
            sender.sendMessage((Component)Component.empty());
            if (sender instanceof Player) {
                Player player = (Player)sender;
                player.sendMessage(Component.text((String)(" Lagging the server for " + millis + " millis using EntityScheduler...")).color(KyoriUtil.AEF_WHITE));
                player.getScheduler().execute((Plugin)plugin, () -> {
                    try {
                        Thread.sleep(millis);
                        player.sendMessage(Component.text((String)" Done.").color(KyoriUtil.AEF_BLUE));
                        player.sendMessage((Component)Component.empty());
                    }
                    catch (InterruptedException e) {
                        sender.sendMessage(Component.text((String)(" Operation was interrupted! - " + e.getLocalizedMessage())).color((TextColor)NamedTextColor.RED));
                        player.sendMessage((Component)Component.empty());
                        AnarchyExploitFixes.logger().error("Lag command encountered an error!", (Throwable)e);
                    }
                }, null, 1L);
            } else {
                sender.sendMessage(Component.text((String)(" Lagging the server for " + millis + " millis using GlobalRegionScheduler...")).color(KyoriUtil.AEF_WHITE));
                plugin.getServer().getGlobalRegionScheduler().execute((Plugin)plugin, () -> {
                    try {
                        Thread.sleep(millis);
                        sender.sendMessage(Component.text((String)" Done.").color(KyoriUtil.AEF_BLUE));
                        sender.sendMessage((Component)Component.empty());
                    }
                    catch (InterruptedException e) {
                        sender.sendMessage(Component.text((String)(" Operation was interrupted! - " + e.getLocalizedMessage())).color((TextColor)NamedTextColor.RED));
                        AnarchyExploitFixes.logger().error("Lag command encountered an error!", (Throwable)e);
                    }
                });
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(Component.text((String)("The value '" + args[1] + "' is not a valid long!")).color((TextColor)NamedTextColor.RED));
        }
        return true;
    }
}

