/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.config;

import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.configmaster.api.ConfigFile;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.libs.xseries.XSound;
import me.xginko.aef.utils.LocaleUtil;
import me.xginko.aef.utils.MathUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Sound;

public class Config {
    private final ConfigFile config;
    public final Locale default_lang;
    public final Sound elytra_too_fast_sound;
    public final Component cmd_say_format;
    public final Duration tickData_cache_duration;
    public final Duration permissions_cache_time;
    public final double elytra_spawn_radius_squared;
    public final long elytra_speed_calc_period;
    public final long elytra_old_chunk_limit;
    public final int nether_ceiling_max_y;
    public final int elytra_spawn_radius;
    public final boolean auto_lang;
    public final boolean packets_disabled;
    public final boolean connectionMsgsAreOnByDefault;
    public final boolean firstJoinMsgsAreOnByDefault;
    public final boolean cmd_say_enabled;
    public final boolean cmd_help_enabled;
    public final boolean cmd_toggleConMsgs_enabled;
    public final boolean cmd_toggleFirstJoinMsgs_enabled;
    public final boolean elytra_enable_at_spawn;
    public final boolean elytra_enable_global;
    public final boolean elytra_enable_netherceiling;
    public final boolean elytra_actionbar_enabled;
    public final boolean elytra_show_chunkage;
    public final boolean elytra_play_too_fast_sound;
    public final boolean elytra_teleport_back;
    public final boolean elytra_calculate_3D;
    public final boolean permissions_hook;
    public final boolean update_checker_enabled;

    public Config() throws Exception {
        Sound parsedSound;
        AnarchyExploitFixes plugin = AnarchyExploitFixes.getInstance();
        this.config = ConfigFile.loadConfig(new File(plugin.getDataFolder(), "config.yml"));
        this.config.set("plugin-version", plugin.getPluginMeta().getVersion());
        this.config.set("server-version", plugin.getServer().getVersion());
        this.structureConfig();
        this.default_lang = LocaleUtil.localeForLanguageTag(this.getString("language.default-language", "en_us", "The default language that will be used if auto-language is set to false \nor no matching language file was found."));
        this.auto_lang = this.getBoolean("language.auto-language", true, "If set to true, will display messages based on client language.");
        this.update_checker_enabled = this.getBoolean("general.update-checker", true, "Displays a console notification if a new version is available on github");
        this.permissions_hook = this.getBoolean("general.permissions.hook", true, "If disabled, wont attempt to hook into any permissions plugin.");
        this.permissions_cache_time = Duration.ofMillis(this.getLong("general.permissions.state-cache-seconds", 5000L, "The time in seconds the plugin will cache the result of Player#hasPermission.\nLonger time is better for performance but it will mean less accuracy if you\ndynamically set/unset permissions on your server."));
        this.tickData_cache_duration = Duration.ofMillis((long)Math.max(1, this.getInt("general.max-tps-check-interval-in-ticks", 20, "The time in ticks (1 sec = 20 ticks) a checked tps will be cached \nby the plugin.")) * 50L);
        this.packets_disabled = this.getBoolean("general.disable-all-packet-listeners", false, "In case packet modules are causing trouble, you can disable them here.");
        this.nether_ceiling_max_y = this.getInt("general.nether-ceiling-y", 127, "The Y-level at which the nether ceiling generates the last layer of bedrock \non your server.");
        this.cmd_say_enabled = this.getBoolean("general.commands.say.enable", false);
        this.cmd_say_format = MiniMessage.miniMessage().deserialize((Object)this.getString("general.commands.say.format", "<gray>SERVER: <gold>%message%", "Uses MiniMessage format: https://docs.advntr.dev/minimessage/format.html."));
        this.cmd_help_enabled = this.getBoolean("general.commands.help.enable", false, "Help command that shows a small command overview for players.");
        this.cmd_toggleConMsgs_enabled = this.getBoolean("general.commands.toggleconnectionmsgs.enable", true, "If you don't use join leave/messages, you can set this to false.");
        this.cmd_toggleFirstJoinMsgs_enabled = this.getBoolean("general.commands.togglefirstjoinmsgs.enable", true, "If you don't use first join messages, you can set this to false.");
        this.config.addComment("general.commands", "A server restart is required when changing a command's enable status!");
        this.elytra_old_chunk_limit = this.getLong("elytra.elytra-speed.old-chunk-inhabited-ticks", 200L, "Time in ticks that a chunk has to have been inhabited to count as old chunk. \nNote that the time is incremented once per tick per player within mob spawning \ndistance of a chunk.");
        this.elytra_speed_calc_period = this.getInt("elytra.elytra-speed.check-period-millis", 500, "The period in millis players will be checked to determine their speed. \nIf you have lagging players with consistent high ping, you can increase this number.");
        this.elytra_calculate_3D = this.getBoolean("elytra.elytra-speed.calculate-3D-speed", false, "If set to false, will only calculate 2-Dimensional speed without taking height \nchanges into consideration.");
        this.elytra_actionbar_enabled = this.getBoolean("elytra.elytra-speed.display-actionbar", true, "Display info in Actionbar while flying.");
        this.elytra_show_chunkage = this.getBoolean("elytra.elytra-speed.display-chunk-info-in-actionbar", true, "Inform flying player if they are in old or new chunks.");
        this.elytra_play_too_fast_sound = this.getBoolean("elytra.elytra-speed.play-sound-when-too-fast", true, "Plays XP pickup sound to alert players when theyre going above the limit.");
        String configuredSound = this.getString("elytra.elytra-speed.sound", XSound.ENTITY_EXPERIENCE_ORB_PICKUP.name());
        try {
            parsedSound = (Sound)XSound.of(configuredSound).orElse(XSound.ENTITY_EXPERIENCE_ORB_PICKUP).get();
        }
        catch (IllegalArgumentException e) {
            AnarchyExploitFixes.logger().warn("<elytra-speed> Sound '{}' does not exist. Using default.", (Object)configuredSound);
            parsedSound = Sound.ENTITY_EXPERIENCE_ORB_PICKUP;
        }
        this.elytra_too_fast_sound = parsedSound;
        this.elytra_teleport_back = this.getBoolean("elytra.elytra-speed.teleport-instead-of-canceling-movement", false, "Recommended to leave false if you dont experience any issues.");
        this.elytra_enable_global = this.getBoolean("elytra.elytra-speed.Global-Settings.enable", true);
        this.elytra_enable_at_spawn = this.getBoolean("elytra.elytra-speed.At-Spawn.enable", false);
        this.elytra_spawn_radius = this.getInt("elytra.elytra-speed.At-Spawn.radius", 3000, "Radius in blocks around 00 that should count as spawn.");
        this.elytra_spawn_radius_squared = MathUtil.square(this.elytra_spawn_radius);
        this.elytra_enable_netherceiling = this.getBoolean("elytra.elytra-speed.Nether-Ceiling.enable", true);
        this.config.addDefault("misc.join-leave-messages.enable", true);
        this.connectionMsgsAreOnByDefault = this.getBoolean("misc.join-leave-messages.show-by-default", true, "If set to true, players will see join/leave messages by default \nand enter /toggleconnectionmsgs to disable them. \nIf set to false will work the other way around.");
        this.firstJoinMsgsAreOnByDefault = this.getBoolean("misc.first-join-messages.show-by-default", true, "If set to true, players will see first join messages by default \nand enter /togglefirstjoinmsgs to disable them. \nIf set to false will work the other way around.");
        this.config.addDefault("misc.join-leave-messages.show-in-console", false);
    }

    public void saveConfig() {
        try {
            this.config.save();
        }
        catch (Exception e) {
            AnarchyExploitFixes.logger().error("Failed to save config file!", (Throwable)e);
        }
    }

    private void structureConfig() {
        this.createTitledSection("Language", "language");
        this.createTitledSection("General", "general");
        this.createTitledSection("Miscellaneous", "misc");
        this.createTitledSection("Chat", "chat");
        this.createTitledSection("Elytra", "elytra");
        this.createTitledSection("Chunk Limits", "chunk-limits");
        this.createTitledSection("Lag Preventions", "lag-preventions");
        this.createTitledSection("Patches", "patches");
        this.createTitledSection("Illegals", "illegals");
        this.createTitledSection("Dupe Preventions", "dupe-preventions");
        this.createTitledSection("Preventions", "preventions");
        this.createTitledSection("Combat", "combat");
    }

    public ConfigFile master() {
        return this.config;
    }

    public void createTitledSection(String title, String path) {
        this.config.addSection(title);
        this.config.addDefault(path, null);
    }

    public boolean getBoolean(String path, boolean def, String comment) {
        this.config.addDefault(path, def, comment);
        return this.config.getBoolean(path, def);
    }

    public boolean getBoolean(String path, boolean def) {
        return this.getBoolean(path, def, null);
    }

    public String getString(String path, String def, String comment) {
        this.config.addDefault(path, def, comment);
        return this.config.getString(path, def);
    }

    public String getString(String path, String def) {
        return this.getString(path, def, null);
    }

    public double getDouble(String path, double def, String comment) {
        this.config.addDefault(path, def, comment);
        return this.config.getDouble(path, def);
    }

    public double getDouble(String path, double def) {
        return this.getDouble(path, def, null);
    }

    public int getInt(String path, int def, String comment) {
        this.config.addDefault(path, def, comment);
        return this.config.getInteger(path, def);
    }

    public int getInt(String path, int def) {
        return this.getInt(path, def, null);
    }

    public long getLong(String path, long def, String comment) {
        this.config.addDefault(path, def, comment);
        return this.config.getLong(path, def);
    }

    public long getLong(String path, long def) {
        return this.getLong(path, def, null);
    }

    public List<String> getList(String path, List<String> def, String comment) {
        this.config.addDefault(path, def, comment);
        return this.config.getStringList(path);
    }

    public List<String> getList(String path, List<String> def) {
        return this.getList(path, def, null);
    }

    public ConfigSection getConfigSection(String path, Map<String, Object> defaultKeyValue, String comment) {
        this.config.addDefault(path, null, comment);
        this.config.makeSectionLenient(path);
        defaultKeyValue.forEach((string, object) -> this.config.addExample(path + "." + string, object));
        return this.config.getConfigSection(path);
    }

    public ConfigSection getConfigSection(String path, Map<String, Object> defaultKeyValue) {
        return this.getConfigSection(path, defaultKeyValue, null);
    }
}

