/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.config;

import java.io.File;
import java.util.List;
import java.util.Locale;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.configmaster.api.ConfigFile;
import me.xginko.aef.utils.KyoriUtil;
import me.xginko.aef.utils.LocaleUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class Translation {
    private final ConfigFile translationFile;
    public final Component no_permission;
    public final Component invalid_syntax;
    public final Component failed_argument_parse;
    public final Component chat_commandwhitelist_badcommand;
    public final Component misc_joinMessage;
    public final Component misc_leaveMessage;
    public final Component misc_MaskedKickMessage;
    public final Component misc_enabledConnectionMsgs;
    public final Component misc_disabledConnectionMsgs;
    public final Component misc_enabledFirstJoinMsgs;
    public final Component misc_disabledFirstJoinMsgs;
    public final Component preventions_witherSpawningDisabledInRadius;
    public final Component elytra_disablePacketElytraFly;
    public final Component elytra_global_YouAreFlyingIn;
    public final Component elytra_global_New;
    public final Component elytra_global_New_UpperCase;
    public final Component elytra_global_Old;
    public final Component elytra_global_Old_UpperCase;
    public final Component elytra_global_Speed;
    public final Component elytra_global_DisabledLowTPS;
    public final Component elytra_global_TooFastLowTPS;
    public final Component elytra_global_TooFastChunkInfo;
    public final Component elytra_disable_timer;
    public final Component elytra_global_TooFast;
    public final Component elytra_global_DisabledHere;
    public final Component elytra_global_Chunks;
    public final Component elytra_ceiling_DisabledHere;
    public final Component elytra_ceiling_Chunks;
    public final Component elytra_ceiling_YouAreFlyingIn;
    public final Component elytra_ceiling_New;
    public final Component elytra_ceiling_New_UpperCase;
    public final Component elytra_ceiling_Old;
    public final Component elytra_ceiling_Old_UpperCase;
    public final Component elytra_ceiling_Speed;
    public final Component elytra_ceiling_DisabledLowTPS;
    public final Component elytra_ceiling_TooFastLowTPS;
    public final Component elytra_ceiling_TooFastChunkInfo;
    public final Component elytra_ceiling_TooFast;
    public final Component elytra_spawn_DisabledHere;
    public final Component elytra_spawn_YouAreFlyingIn;
    public final Component elytra_spawn_New;
    public final Component elytra_spawn_New_UpperCase;
    public final Component elytra_spawn_Old;
    public final Component elytra_spawn_Old_UpperCase;
    public final Component elytra_spawn_Speed;
    public final Component elytra_spawn_DisabledLowTPS;
    public final Component elytra_spawn_TooFast;
    public final Component elytra_spawn_TooFastChunkInfo;
    public final Component elytra_spawn_Chunks;
    public final Component lagpreventions_stopSpammingLevers;
    public final List<Component> misc_firstJoinMessage;
    public final List<Component> help_Message;

    public Translation(Locale locale) throws Exception {
        AnarchyExploitFixes plugin = AnarchyExploitFixes.getInstance();
        String langFileName = LocaleUtil.languageTagForLocale(locale) + ".yml";
        File langYML = new File(String.valueOf(plugin.getDataFolder()) + "/lang", langFileName);
        if (!langYML.exists()) {
            plugin.saveResource("lang/" + langFileName, false);
        }
        this.translationFile = ConfigFile.loadConfig(langYML);
        this.no_permission = this.getTranslation("commands.no-permission", "<red>You don't have permission to use this command.");
        this.invalid_syntax = this.getTranslation("commands.invalid-syntax", "<red>Invalid command syntax. Correct syntax: <gray>%syntax%");
        this.failed_argument_parse = this.getTranslation("commands.failed-argument-parse", "<red>Failed to parse command arguments.");
        this.help_Message = this.getListTranslation("commands.help-command", List.of("<dark_aqua>----------------------------------------------------", "<gray>/toggleconnectionmsgs <dark_gray>- <gray>Turns off join messages", "<gray>/toggledeathmsgs <dark_gray>- <gray>Turns off death messages", "<gray>/toggletells <dark_gray>- <gray>Turns off private messages", "<gray>/togglechat <dark_gray>- <gray>Turns off chat messages", "<gray>/ignore <dark_gray>- <gray>Ignore certain players", "<gray>/seed <dark_gray>- <gray>Shows the server seed", "<gray>/kill <dark_gray>- <gray>Kills you", "<gray>/reply <dark_gray>- <gray>Reply to messages", "<gray>/msg <dark_gray>- <gray>Message other players", "<gray>/stats <dark_gray>- <gray>Shows world statistics", "<dark_aqua>----------------------------------------------------"));
        this.chat_commandwhitelist_badcommand = this.getTranslation("command-whitelist.bad-command", "<dark_red>Bad command. Type /help for a list of commands.");
        this.misc_joinMessage = this.getTranslation("join-leave-messages.join", "<gray>%player% joined the game.");
        this.misc_leaveMessage = this.getTranslation("join-leave-messages.leave", "<gray>%player% left the game.");
        this.misc_enabledConnectionMsgs = this.getTranslation("join-leave-messages.enabled-connection-msgs", "<gray>Enabled connection msgs");
        this.misc_disabledConnectionMsgs = this.getTranslation("join-leave-messages.disabled-connection-msgs", "<gray>Disabled connection msgs");
        this.misc_enabledFirstJoinMsgs = this.getTranslation("join-leave-messages.enabled-first-join-msgs", "<gray>Enabled first join msgs");
        this.misc_disabledFirstJoinMsgs = this.getTranslation("join-leave-messages.disabled-first-join-msgs", "<gray>Disabled first join msgs");
        this.misc_firstJoinMessage = this.getListTranslation("join-leave-messages.first-join", List.of("<gray>%player% joined the game for the first time. They are %players_num% to join."));
        this.misc_MaskedKickMessage = this.getTranslation("kicks.masked-kick-message", "<gold>Disconnected");
        this.lagpreventions_stopSpammingLevers = this.getTranslation("redstone.stop-spamming-levers", "<red>Stop spamming levers.");
        this.preventions_witherSpawningDisabledInRadius = this.getTranslation("withers.disabled-at-spawn", "<dark_red>Wither spawning is disabled in a radius of %radius% blocks around spawn.");
        this.elytra_disablePacketElytraFly = this.getTranslation("elytra.disable-packet-elytrafly", "<red>Disable Packet Elytra Fly.");
        this.elytra_disable_timer = this.getTranslation("elytra.disable-timer", "<red>Disable Timer when traveling with an elytra.");
        this.elytra_global_DisabledHere = this.getTranslation("elytra.elytra-speed.global.disabled-here", "<red>Elytras are currently disabled.");
        this.elytra_global_YouAreFlyingIn = this.getTranslation("elytra.elytra-speed.global.you-are-flying-in", "<gray>You are flying in %neworold% <gray>%chunks%");
        this.elytra_global_New = this.getTranslation("elytra.elytra-speed.global.new", "new");
        this.elytra_global_New_UpperCase = KyoriUtil.toUpperCase(this.elytra_global_New, locale).style(this.getTranslation("elytra.elytra-speed.global.color-newchunks", "<dark_red>").style());
        this.elytra_global_Old = this.getTranslation("elytra.elytra-speed.global.old", "old");
        this.elytra_global_Old_UpperCase = KyoriUtil.toUpperCase(this.elytra_global_Old, locale).style(this.getTranslation("elytra.elytra-speed.global.color-oldchunks", "<green>").style());
        this.elytra_global_Speed = this.getTranslation("elytra.elytra-speed.global.speed", "<gray>Speed: %speed% / %maxspeed%");
        this.elytra_global_DisabledLowTPS = this.getTranslation("elytra.elytra-speed.global.disabled-low-tps", "<red>Elytras are currently disabled because the tps is lower than %tps%.");
        this.elytra_global_TooFastLowTPS = this.getTranslation("elytra.elytra-speed.global.going-too-fast-low-tps", "<red>Elytra speed is reduced during low tps. Turn down your settings.");
        this.elytra_global_TooFastChunkInfo = this.getTranslation("elytra.elytra-speed.global.going-too-fast-chunkinfo", "<red>Turn down your settings. Elytra speed is restricted in %neworold% %chunks%");
        this.elytra_global_TooFast = this.getTranslation("elytra.elytra-speed.global.going-too-fast", "<red>Turn down your settings. Elytra speed is restricted on this server.");
        this.elytra_global_Chunks = this.getTranslation("elytra.elytra-speed.global.chunks", "chunks");
        this.elytra_ceiling_DisabledHere = this.getTranslation("elytra.elytra-speed.nether-ceiling.disabled-here", "<red>Elytras are disabled on the nether ceiling.");
        this.elytra_ceiling_YouAreFlyingIn = this.getTranslation("elytra.elytra-speed.nether-ceiling.you-are-flying-in", "<gray>You are flying in %neworold% <gray>%chunks%");
        this.elytra_ceiling_New = this.getTranslation("elytra.elytra-speed.nether-ceiling.new", "new");
        this.elytra_ceiling_New_UpperCase = KyoriUtil.toUpperCase(this.elytra_global_New_UpperCase, locale).style(this.getTranslation("elytra.elytra-speed.nether-ceiling.color-newchunks", "<dark_red>").style());
        this.elytra_ceiling_Old = this.getTranslation("elytra.elytra-speed.nether-ceiling.old", "old");
        this.elytra_ceiling_Old_UpperCase = KyoriUtil.toUpperCase(this.elytra_ceiling_Old, locale).style(this.getTranslation("elytra.elytra-speed.nether-ceiling.color-oldchunks", "<green>").style());
        this.elytra_ceiling_Speed = this.getTranslation("elytra.elytra-speed.nether-ceiling.speed", "<gray>Speed: %speed% / %maxspeed%");
        this.elytra_ceiling_DisabledLowTPS = this.getTranslation("elytra.elytra-speed.nether-ceiling.disabled-low-tps", "<red>Elytras are currently disabled because the tps is lower than %tps%.");
        this.elytra_ceiling_TooFastLowTPS = this.getTranslation("elytra.elytra-speed.nether-ceiling.going-too-fast-low-tps", "<red>Elytra speed is reduced during low tps. Turn down your settings.");
        this.elytra_ceiling_TooFastChunkInfo = this.getTranslation("elytra.elytra-speed.nether-ceiling.going-too-fast-chunkinfo", "<red>Turn down your settings. Elytra speed is restricted in %neworold% %chunks%");
        this.elytra_ceiling_TooFast = this.getTranslation("elytra.elytra-speed.nether-ceiling.going-too-fast", "<red>Turn down your settings. Elytra speed is restricted on the nether ceiling.");
        this.elytra_ceiling_Chunks = this.getTranslation("elytra.elytra-speed.nether-ceiling.chunks", "ceiling chunks");
        this.elytra_spawn_DisabledHere = this.getTranslation("elytra.elytra-speed.spawn.disabled-here", "<red>Elytras are disabled in a range of <gold>%range% <red>blocks around spawn.");
        this.elytra_spawn_YouAreFlyingIn = this.getTranslation("elytra.elytra-speed.spawn.you-are-flying-in", "<gray>You are flying in %neworold% <gray>%chunks%");
        this.elytra_spawn_New = this.getTranslation("elytra.elytra-speed.spawn.new", "new");
        this.elytra_spawn_New_UpperCase = KyoriUtil.toUpperCase(this.elytra_spawn_New, locale).style(this.getTranslation("elytra.elytra-speed.spawn.color-newchunks", "<dark_red>").style());
        this.elytra_spawn_Old = this.getTranslation("elytra.elytra-speed.spawn.old", "old");
        this.elytra_spawn_Old_UpperCase = KyoriUtil.toUpperCase(this.elytra_spawn_Old, locale).style(this.getTranslation("elytra.elytra-speed.spawn.color-oldchunks", "<green>").style());
        this.elytra_spawn_Speed = this.getTranslation("elytra.elytra-speed.spawn.speed", "<gray>Speed: %speed% / %maxspeed%");
        this.elytra_spawn_DisabledLowTPS = this.getTranslation("elytra.elytra-speed.spawn.disabled-low-tps", "<red>Elytras are currently disabled because the tps is lower than %tps%.");
        this.elytra_spawn_TooFastChunkInfo = this.getTranslation("elytra.elytra-speed.spawn.going-too-fast-chunkinfo", "<red>Elytra speed is restricted in %neworold% %chunks% in a radius of %radius% blocks.");
        this.elytra_spawn_TooFast = this.getTranslation("elytra.elytra-speed.nether-ceiling.going-too-fast", "<red>Elytra speed is restricted in a radius of %radius% blocks around spawn.");
        this.elytra_spawn_Chunks = this.getTranslation("elytra.elytra-speed.spawn.chunks", "spawn chunks");
        try {
            this.translationFile.save();
        }
        catch (Exception e) {
            AnarchyExploitFixes.logger().error("Failed to save language file: {}!", (Object)langYML.getName(), (Object)e);
        }
    }

    private Component getTranslation(String path, String defaultTranslation) {
        this.translationFile.addDefault(path, defaultTranslation);
        return MiniMessage.miniMessage().deserialize((Object)KyoriUtil.translateChatColor(this.translationFile.getString(path, defaultTranslation)));
    }

    private Component getTranslation(String path, String defaultTranslation, String comment) {
        this.translationFile.addDefault(path, defaultTranslation, comment);
        return MiniMessage.miniMessage().deserialize((Object)KyoriUtil.translateChatColor(this.translationFile.getString(path, defaultTranslation)));
    }

    private List<Component> getListTranslation(String path, List<String> defaultTranslation) {
        this.translationFile.addDefault(path, defaultTranslation);
        return this.translationFile.getStringList(path).stream().map(KyoriUtil::translateChatColor).map(arg_0 -> ((MiniMessage)MiniMessage.miniMessage()).deserialize(arg_0)).toList();
    }

    private List<Component> getListTranslation(String path, List<String> defaultTranslation, String comment) {
        this.translationFile.addDefault(path, defaultTranslation, comment);
        return this.translationFile.getStringList(path).stream().map(KyoriUtil::translateChatColor).map(arg_0 -> ((MiniMessage)MiniMessage.miniMessage()).deserialize(arg_0)).toList();
    }
}

