/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.libs.caffeine.cache;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.libs.caffeine.cache.Expiry;

final class ExpiryAfterCreate<K, V>
implements Expiry<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    final BiFunction<K, V, Duration> function;

    public ExpiryAfterCreate(BiFunction<K, V, Duration> calculator) {
        this.function = Objects.requireNonNull(calculator);
    }

    @Override
    public long expireAfterCreate(K key, V value, long currentTime) {
        return Caffeine.toNanosSaturated(this.function.apply(key, value));
    }

    @Override
    @CanIgnoreReturnValue
    public long expireAfterUpdate(K key, V value, long currentTime, long currentDuration) {
        return currentDuration;
    }

    @Override
    @CanIgnoreReturnValue
    public long expireAfterRead(K key, V value, long currentTime, long currentDuration) {
        return currentDuration;
    }
}

