/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.libs.caffeine.cache;

import me.xginko.aef.libs.caffeine.cache.AsyncCacheLoader;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.libs.caffeine.cache.LocalCacheFactory;
import me.xginko.aef.libs.caffeine.cache.Node;
import me.xginko.aef.libs.caffeine.cache.Pacer;
import me.xginko.aef.libs.caffeine.cache.Scheduler;
import me.xginko.aef.libs.caffeine.cache.Ticker;
import me.xginko.aef.libs.caffeine.cache.WILMS;
import me.xginko.aef.libs.caffeine.cache.WriteOrderDeque;

class WILMSW<K, V>
extends WILMS<K, V> {
    static final LocalCacheFactory FACTORY = WILMSW::new;
    final Ticker ticker;
    final WriteOrderDeque<Node<K, V>> writeOrderDeque;
    volatile long expiresAfterWriteNanos;
    final Pacer pacer;

    WILMSW(Caffeine<K, V> caffeine, AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.writeOrderDeque = new WriteOrderDeque();
        this.expiresAfterWriteNanos = caffeine.getExpiresAfterWriteNanos();
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
        return this.writeOrderDeque;
    }

    @Override
    protected final boolean expiresAfterWrite() {
        return true;
    }

    @Override
    protected final long expiresAfterWriteNanos() {
        return this.expiresAfterWriteNanos;
    }

    @Override
    protected final void setExpiresAfterWriteNanos(long l) {
        this.expiresAfterWriteNanos = l;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

