/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.libs.caffeine.cache;

import me.xginko.aef.libs.caffeine.cache.AsyncCacheLoader;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.libs.caffeine.cache.Expiry;
import me.xginko.aef.libs.caffeine.cache.LocalCacheFactory;
import me.xginko.aef.libs.caffeine.cache.Pacer;
import me.xginko.aef.libs.caffeine.cache.Scheduler;
import me.xginko.aef.libs.caffeine.cache.Ticker;
import me.xginko.aef.libs.caffeine.cache.TimerWheel;
import me.xginko.aef.libs.caffeine.cache.WSLMS;

class WSLMSA<K, V>
extends WSLMS<K, V> {
    static final LocalCacheFactory FACTORY = WSLMSA::new;
    final Ticker ticker;
    final Expiry<K, V> expiry;
    final TimerWheel<K, V> timerWheel;
    volatile long expiresAfterAccessNanos;
    final Pacer pacer;

    WSLMSA(Caffeine<K, V> caffeine, AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.expiry = caffeine.getExpiry(this.isAsync);
        this.timerWheel = caffeine.expiresVariable() ? new TimerWheel() : null;
        this.expiresAfterAccessNanos = caffeine.getExpiresAfterAccessNanos();
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final boolean expiresVariable() {
        return this.timerWheel != null;
    }

    @Override
    public final Expiry<K, V> expiry() {
        return this.expiry;
    }

    @Override
    protected final TimerWheel<K, V> timerWheel() {
        return this.timerWheel;
    }

    @Override
    protected final boolean expiresAfterAccess() {
        return this.timerWheel == null;
    }

    @Override
    protected final long expiresAfterAccessNanos() {
        return this.expiresAfterAccessNanos;
    }

    @Override
    protected final void setExpiresAfterAccessNanos(long l) {
        this.expiresAfterAccessNanos = l;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

